@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes Dolby Digital Audio Codec (AC3) audio encoding settings. The current implementation for Dolby Digital Audio support are: Audio channel numbers at 1((mono), 2(stereo), 6(5.1side); Audio sampling frequency rates at: 32K/44.1K/48K Hz; Audio bitrate values as AC3 specification supports: 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000 bps.
 * @property bitrate The bitrate, in bits per second, of the output encoded audio.
 * @property channels The number of channels in the audio.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.DDAudio'.
 * @property samplingRate The sampling rate to use for encoding in hertz.
 */
public data class DDAudioResponse(
    public val bitrate: Int? = null,
    public val channels: Int? = null,
    public val label: String? = null,
    public val odataType: String,
    public val samplingRate: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.DDAudioResponse): DDAudioResponse = DDAudioResponse(
            bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
            channels = javaType.channels().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            samplingRate = javaType.samplingRate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
