@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the de-interlacing settings.
 * @property mode The deinterlacing mode. Defaults to AutoPixelAdaptive.
 * @property parity The field parity for de-interlacing, defaults to Auto.
 */
public data class DeinterlaceResponse(
    public val mode: String? = null,
    public val parity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.DeinterlaceResponse): DeinterlaceResponse = DeinterlaceResponse(
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            parity = javaType.parity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
