@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataCollectionFrequency Usage data collection frequency in ISO 8601 duration format e.g. PT10M , PT5H.
 * @property dataReportingFrequency Usage data reporting frequency in ISO 8601 duration format e.g. PT10M , PT5H.
 * @property eventHubDetails Details of Event Hub where the usage will be reported.
 * @property maxAllowedUnreportedUsageDuration Maximum time for which the functionality of the device will not be hampered for not reporting the usage data.
 */
public data class EdgeUsageDataCollectionPolicyResponse(
    public val dataCollectionFrequency: String? = null,
    public val dataReportingFrequency: String? = null,
    public val eventHubDetails: EdgeUsageDataEventHubResponse? = null,
    public val maxAllowedUnreportedUsageDuration: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.EdgeUsageDataCollectionPolicyResponse): EdgeUsageDataCollectionPolicyResponse = EdgeUsageDataCollectionPolicyResponse(
            dataCollectionFrequency = javaType.dataCollectionFrequency().map({ args0 -> args0 }).orElse(null),
            dataReportingFrequency = javaType.dataReportingFrequency().map({ args0 -> args0 }).orElse(null),
            eventHubDetails = javaType.eventHubDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.EdgeUsageDataEventHubResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maxAllowedUnreportedUsageDuration = javaType.maxAllowedUnreportedUsageDuration().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
