@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name of the Event Hub where usage will be reported.
 * @property namespace Namespace of the Event Hub where usage will be reported.
 * @property token SAS token needed to interact with Event Hub.
 */
public data class EdgeUsageDataEventHubResponse(
    public val name: String? = null,
    public val namespace: String? = null,
    public val token: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.EdgeUsageDataEventHubResponse): EdgeUsageDataEventHubResponse = EdgeUsageDataEventHubResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            token = javaType.token().map({ args0 -> args0 }).orElse(null),
        )
    }
}
