@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes all the settings to be used when analyzing a video in order to detect (and optionally redact) all the faces present.
 * @property blurType Blur type
 * @property experimentalOptions Dictionary containing key value pairs for parameters not exposed in the preset itself
 * @property mode This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.FaceDetectorPreset'.
 * @property resolution Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
 */
public data class FaceDetectorPresetResponse(
    public val blurType: String? = null,
    public val experimentalOptions: Map<String, String>? = null,
    public val mode: String? = null,
    public val odataType: String,
    public val resolution: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.FaceDetectorPresetResponse): FaceDetectorPresetResponse = FaceDetectorPresetResponse(
            blurType = javaType.blurType().map({ args0 -> args0 }).orElse(null),
            experimentalOptions = javaType.experimentalOptions().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            resolution = javaType.resolution().map({ args0 -> args0 }).orElse(null),
        )
    }
}
