@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The class to specify one track property condition.
 * @property operation The track property condition operation.
 * @property property The track property type.
 * @property value The track property value.
 */
public data class FilterTrackPropertyConditionResponse(
    public val operation: String,
    public val `property`: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.FilterTrackPropertyConditionResponse): FilterTrackPropertyConditionResponse = FilterTrackPropertyConditionResponse(
            operation = javaType.operation(),
            `property` = javaType.`property`(),
            `value` = javaType.`value`(),
        )
    }
}
