@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation.
 * @property trackSelections The track selections.
 */
public data class FilterTrackSelectionResponse(
    public val trackSelections: List<FilterTrackPropertyConditionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.FilterTrackSelectionResponse): FilterTrackSelectionResponse = FilterTrackSelectionResponse(
            trackSelections = javaType.trackSelections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.FilterTrackPropertyConditionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
