@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input media before encoding.
 * @property crop The parameters for the rectangular window with which to crop the input video.
 * @property deinterlace The de-interlacing settings.
 * @property fadeIn Describes the properties of a Fade effect applied to the input media.
 * @property fadeOut Describes the properties of a Fade effect applied to the input media.
 * @property overlays The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
 * @property rotation The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
 */
public data class FiltersResponse(
    public val crop: RectangleResponse? = null,
    public val deinterlace: DeinterlaceResponse? = null,
    public val fadeIn: FadeResponse? = null,
    public val fadeOut: FadeResponse? = null,
    public val overlays: List<Either<AudioOverlayResponse, VideoOverlayResponse>>? = null,
    public val rotation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.FiltersResponse): FiltersResponse = FiltersResponse(
            crop = javaType.crop().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.RectangleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deinterlace = javaType.deinterlace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.DeinterlaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fadeIn = javaType.fadeIn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.FadeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fadeOut = javaType.fadeOut().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.FadeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            overlays = javaType.overlays().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.media.kotlin.outputs.AudioOverlayResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.media.kotlin.outputs.VideoOverlayResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            rotation = javaType.rotation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
