@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An Asset Filter.
 * @property firstQuality The first quality.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property presentationTimeRange The presentation time range.
 * @property systemData The system metadata relating to this resource.
 * @property tracks The tracks selection conditions.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAssetFilterResult(
    public val firstQuality: FirstQualityResponse? = null,
    public val id: String,
    public val name: String,
    public val presentationTimeRange: PresentationTimeRangeResponse? = null,
    public val systemData: SystemDataResponse,
    public val tracks: List<FilterTrackSelectionResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetAssetFilterResult): GetAssetFilterResult = GetAssetFilterResult(
            firstQuality = javaType.firstQuality().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.FirstQualityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            presentationTimeRange = javaType.presentationTimeRange().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.PresentationTimeRangeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tracks = javaType.tracks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.FilterTrackSelectionResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
