@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Asset.
 * @property alternateId The alternate ID of the Asset.
 * @property assetId The Asset ID.
 * @property container The name of the asset blob container.
 * @property created The creation date of the Asset.
 * @property description The Asset description.
 * @property encryptionScope The Asset container encryption scope in the storage account.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModified The last modified date of the Asset.
 * @property name The name of the resource
 * @property storageAccountName The name of the storage account.
 * @property storageEncryptionFormat The Asset encryption format. One of None or MediaStorageEncryption.
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAssetResult(
    public val alternateId: String? = null,
    public val assetId: String,
    public val container: String? = null,
    public val created: String,
    public val description: String? = null,
    public val encryptionScope: String? = null,
    public val id: String,
    public val lastModified: String,
    public val name: String,
    public val storageAccountName: String? = null,
    public val storageEncryptionFormat: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetAssetResult): GetAssetResult = GetAssetResult(
            alternateId = javaType.alternateId().map({ args0 -> args0 }).orElse(null),
            assetId = javaType.assetId(),
            container = javaType.container().map({ args0 -> args0 }).orElse(null),
            created = javaType.created(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptionScope = javaType.encryptionScope().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            name = javaType.name(),
            storageAccountName = javaType.storageAccountName().map({ args0 -> args0 }).orElse(null),
            storageEncryptionFormat = javaType.storageEncryptionFormat(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
