@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of the Content Key Policy.
 * @property created The creation date of the Policy
 * @property description A description for the Policy.
 * @property lastModified The last modified date of the Policy
 * @property options The Key Policy options.
 * @property policyId The legacy Policy ID.
 */
public data class GetContentKeyPolicyPropertiesWithSecretsResult(
    public val created: String,
    public val description: String? = null,
    public val lastModified: String,
    public val options: List<ContentKeyPolicyOptionResponse>,
    public val policyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetContentKeyPolicyPropertiesWithSecretsResult): GetContentKeyPolicyPropertiesWithSecretsResult =
            GetContentKeyPolicyPropertiesWithSecretsResult(
                created = javaType.created(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                lastModified = javaType.lastModified(),
                options = javaType.options().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyOptionResponse.Companion.toKotlin(args0)
                    })
                }),
                policyId = javaType.policyId(),
            )
    }
}
