@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The live event.
 * @property created The creation time for the live event
 * @property crossSiteAccessPolicies Live event cross site access policies.
 * @property description A description for the live event.
 * @property encoding Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for the live encoder if it is used.
 * @property hostnamePrefix When useStaticHostname is set to true, the hostnamePrefix specifies the first part of the hostname assigned to the live event preview and ingest endpoints. The final hostname would be a combination of this prefix, the media service account name and a short code for the Azure Media Services data center.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property input Live event input settings. It defines how the live event receives input from a contribution encoder.
 * @property lastModified The last modified time of the live event.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property preview Live event preview settings. Preview allows live event producers to preview the live streaming content without creating any live output.
 * @property provisioningState The provisioning state of the live event.
 * @property resourceState The resource state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information.
 * @property streamOptions The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values for the array entry values are 'Default' and 'LowLatency'.
 * @property systemData The system metadata relating to this resource.
 * @property tags Resource tags.
 * @property transcriptions Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property useStaticHostname Specifies whether a static hostname would be assigned to the live event preview and ingest endpoints. This value can only be updated if the live event is in Standby state
 */
public data class GetLiveEventResult(
    public val created: String,
    public val crossSiteAccessPolicies: CrossSiteAccessPoliciesResponse? = null,
    public val description: String? = null,
    public val encoding: LiveEventEncodingResponse? = null,
    public val hostnamePrefix: String? = null,
    public val id: String,
    public val input: LiveEventInputResponse,
    public val lastModified: String,
    public val location: String,
    public val name: String,
    public val preview: LiveEventPreviewResponse? = null,
    public val provisioningState: String,
    public val resourceState: String,
    public val streamOptions: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val transcriptions: List<LiveEventTranscriptionResponse>? = null,
    public val type: String,
    public val useStaticHostname: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetLiveEventResult): GetLiveEventResult = GetLiveEventResult(
            created = javaType.created(),
            crossSiteAccessPolicies = javaType.crossSiteAccessPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.CrossSiteAccessPoliciesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encoding = javaType.encoding().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventEncodingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostnamePrefix = javaType.hostnamePrefix().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            input = javaType.input().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.LiveEventInputResponse.Companion.toKotlin(args0)
            }),
            lastModified = javaType.lastModified(),
            location = javaType.location(),
            name = javaType.name(),
            preview = javaType.preview().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventPreviewResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            streamOptions = javaType.streamOptions().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transcriptions = javaType.transcriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventTranscriptionResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            useStaticHostname = javaType.useStaticHostname().map({ args0 -> args0 }).orElse(null),
        )
    }
}
