@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The Live Output.
 * @property archiveWindowLength ISO 8601 time between 1 minute to 25 hours to indicate the maximum content length that can be archived in the asset for this live output. This also sets the maximum content length for the rewind window. For example, use PT1H30M to indicate 1 hour and 30 minutes of archive window.
 * @property assetName The asset that the live output will write to.
 * @property created The creation time the live output.
 * @property description The description of the live output.
 * @property hls HTTP Live Streaming (HLS) packing setting for the live output.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModified The time the live output was last modified.
 * @property manifestName The manifest file name. If not provided, the service will generate one automatically.
 * @property name The name of the resource
 * @property outputSnapTime The initial timestamp that the live output will start at, any content before this value will not be archived.
 * @property provisioningState The provisioning state of the live output.
 * @property resourceState The resource state of the live output.
 * @property rewindWindowLength ISO 8601 time between 1 minute to the duration of archiveWindowLength to control seek-able window length during Live. The service won't use this property once LiveOutput stops. The archived VOD will have full content with original ArchiveWindowLength. For example, use PT1H30M to indicate 1 hour and 30 minutes of rewind window length. Service will use implicit default value 30m only if Live Event enables LL.
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLiveOutputResult(
    public val archiveWindowLength: String,
    public val assetName: String,
    public val created: String,
    public val description: String? = null,
    public val hls: HlsResponse? = null,
    public val id: String,
    public val lastModified: String,
    public val manifestName: String? = null,
    public val name: String,
    public val outputSnapTime: Double? = null,
    public val provisioningState: String,
    public val resourceState: String,
    public val rewindWindowLength: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetLiveOutputResult): GetLiveOutputResult = GetLiveOutputResult(
            archiveWindowLength = javaType.archiveWindowLength(),
            assetName = javaType.assetName(),
            created = javaType.created(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            hls = javaType.hls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.HlsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            manifestName = javaType.manifestName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            outputSnapTime = javaType.outputSnapTime().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            rewindWindowLength = javaType.rewindWindowLength().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
