@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Media Graph.
 * @property created Date the Media Graph was created.
 * @property description Media Graph description.
 * @property id Fully qualified resource ID for the resource.
 * @property lastModified Date the Media Graph was last modified.
 * @property name The name of the resource.
 * @property sinks Media Graph sinks.
 * @property sources Media Graph sources.
 * @property state Media Graph state which indicates the resource allocation status for running the media graph pipeline.
 * @property type The type of the resource.
 */
public data class GetMediaGraphResult(
    public val created: String,
    public val description: String? = null,
    public val id: String,
    public val lastModified: String,
    public val name: String,
    public val sinks: List<MediaGraphAssetSinkResponse>,
    public val sources: List<MediaGraphRtspSourceResponse>,
    public val state: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetMediaGraphResult): GetMediaGraphResult = GetMediaGraphResult(
            created = javaType.created(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            name = javaType.name(),
            sinks = javaType.sinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.MediaGraphAssetSinkResponse.Companion.toKotlin(args0)
                })
            }),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.MediaGraphRtspSourceResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state(),
            type = javaType.type(),
        )
    }
}
