@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A Streaming Locator resource
 * @property alternativeMediaId Alternative Media ID of this Streaming Locator
 * @property assetName Asset Name
 * @property contentKeys The ContentKeys used by this Streaming Locator.
 * @property created The creation time of the Streaming Locator.
 * @property defaultContentKeyPolicyName Name of the default ContentKeyPolicy used by this Streaming Locator.
 * @property endTime The end time of the Streaming Locator.
 * @property filters A list of asset or account filters which apply to this streaming locator
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property startTime The start time of the Streaming Locator.
 * @property streamingLocatorId The StreamingLocatorId of the Streaming Locator.
 * @property streamingPolicyName Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you created or use one of the predefined Streaming Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly', 'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStreamingLocatorResult(
    public val alternativeMediaId: String? = null,
    public val assetName: String,
    public val contentKeys: List<StreamingLocatorContentKeyResponse>? = null,
    public val created: String,
    public val defaultContentKeyPolicyName: String? = null,
    public val endTime: String? = null,
    public val filters: List<String>? = null,
    public val id: String,
    public val name: String,
    public val startTime: String? = null,
    public val streamingLocatorId: String? = null,
    public val streamingPolicyName: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetStreamingLocatorResult): GetStreamingLocatorResult = GetStreamingLocatorResult(
            alternativeMediaId = javaType.alternativeMediaId().map({ args0 -> args0 }).orElse(null),
            assetName = javaType.assetName(),
            contentKeys = javaType.contentKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingLocatorContentKeyResponse.Companion.toKotlin(args0)
                })
            }),
            created = javaType.created(),
            defaultContentKeyPolicyName = javaType.defaultContentKeyPolicyName().map({ args0 ->
                args0
            }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            filters = javaType.filters().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            streamingLocatorId = javaType.streamingLocatorId().map({ args0 -> args0 }).orElse(null),
            streamingPolicyName = javaType.streamingPolicyName(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
