@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A Streaming Policy resource
 * @property commonEncryptionCbcs Configuration of CommonEncryptionCbcs
 * @property commonEncryptionCenc Configuration of CommonEncryptionCenc
 * @property created Creation time of Streaming Policy
 * @property defaultContentKeyPolicyName Default ContentKey used by current Streaming Policy
 * @property envelopeEncryption Configuration of EnvelopeEncryption
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property noEncryption Configurations of NoEncryption
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStreamingPolicyResult(
    public val commonEncryptionCbcs: CommonEncryptionCbcsResponse? = null,
    public val commonEncryptionCenc: CommonEncryptionCencResponse? = null,
    public val created: String,
    public val defaultContentKeyPolicyName: String? = null,
    public val envelopeEncryption: EnvelopeEncryptionResponse? = null,
    public val id: String,
    public val name: String,
    public val noEncryption: NoEncryptionResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetStreamingPolicyResult): GetStreamingPolicyResult = GetStreamingPolicyResult(
            commonEncryptionCbcs = javaType.commonEncryptionCbcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.CommonEncryptionCbcsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            commonEncryptionCenc = javaType.commonEncryptionCenc().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.CommonEncryptionCencResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            created = javaType.created(),
            defaultContentKeyPolicyName = javaType.defaultContentKeyPolicyName().map({ args0 ->
                args0
            }).orElse(null),
            envelopeEncryption = javaType.envelopeEncryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.EnvelopeEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            noEncryption = javaType.noEncryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.NoEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
