@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A Transform encapsulates the rules or instructions for generating desired outputs from input media, such as by transcoding or by extracting insights. After the Transform is created, it can be applied to input media by creating Jobs.
 * @property created The UTC date and time when the Transform was created, in 'YYYY-MM-DDThh:mm:ssZ' format.
 * @property description An optional verbose description of the Transform.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModified The UTC date and time when the Transform was last updated, in 'YYYY-MM-DDThh:mm:ssZ' format.
 * @property name The name of the resource
 * @property outputs An array of one or more TransformOutputs that the Transform should generate.
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTransformResult(
    public val created: String,
    public val description: String? = null,
    public val id: String,
    public val lastModified: String,
    public val name: String,
    public val outputs: List<TransformOutputResponse>,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetTransformResult): GetTransformResult = GetTransformResult(
            created = javaType.created(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            name = javaType.name(),
            outputs = javaType.outputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.TransformOutputResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
