@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An InputDefinition for a single file.  TrackSelections are scoped to the file specified.
 * @property filename Name of the file that this input definition applies to.
 * @property includedTracks The list of TrackDescriptors which define the metadata and selection of tracks in the input.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.InputFile'.
 */
public data class InputFileResponse(
    public val filename: String? = null,
    public val includedTracks: List<Any>? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.InputFileResponse): InputFileResponse = InputFileResponse(
            filename = javaType.filename().map({ args0 -> args0 }).orElse(null),
            includedTracks = javaType.includedTracks().map({ args0 -> args0 }),
            odataType = javaType.odataType(),
        )
    }
}
