@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of JobOutput errors.
 * @property category Helps with categorization of errors.
 * @property code Error code describing the error.
 * @property details An array of details about specific errors that led to this reported error.
 * @property message A human-readable language-dependent representation of the error.
 * @property retry Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via Azure Portal.
 */
public data class JobErrorResponse(
    public val category: String,
    public val code: String,
    public val details: List<JobErrorDetailResponse>,
    public val message: String,
    public val retry: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.JobErrorResponse): JobErrorResponse = JobErrorResponse(
            category = javaType.category(),
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.JobErrorDetailResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
            retry = javaType.retry(),
        )
    }
}
