@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a list of inputs to a Job.
 * @property inputs List of inputs to a Job.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.JobInputs'.
 */
public data class JobInputsResponse(
    public val inputs: List<Any>? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.JobInputsResponse): JobInputsResponse = JobInputsResponse(
            inputs = javaType.inputs().map({ args0 -> args0 }),
            odataType = javaType.odataType(),
        )
    }
}
