@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents an Asset used as a JobOutput.
 * @property assetName The name of the output Asset.
 * @property endTime The UTC date and time at which this Job Output finished processing.
 * @property error If the JobOutput is in the Error state, it contains the details of the error.
 * @property label A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.JobOutputAsset'.
 * @property presetOverride A preset used to override the preset in the corresponding transform output.
 * @property progress If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate and not intended to be used to predict Job completion times. To determine if the JobOutput is complete, use the State property.
 * @property startTime The UTC date and time at which this Job Output began processing.
 * @property state Describes the state of the JobOutput.
 */
public data class JobOutputAssetResponse(
    public val assetName: String,
    public val endTime: String,
    public val error: JobErrorResponse,
    public val label: String? = null,
    public val odataType: String,
    public val presetOverride: Any? = null,
    public val progress: Int,
    public val startTime: String,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.JobOutputAssetResponse): JobOutputAssetResponse = JobOutputAssetResponse(
            assetName = javaType.assetName(),
            endTime = javaType.endTime(),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.JobErrorResponse.Companion.toKotlin(args0)
            }),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            presetOverride = javaType.presetOverride().map({ args0 -> args0 }).orElse(null),
            progress = javaType.progress(),
            startTime = javaType.startTime(),
            state = javaType.state(),
        )
    }
}
