@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the properties for producing a series of JPEG images from the input video.
 * @property keyFrameInterval The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property layers A collection of output JPEG image layers to be produced by the encoder.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.JpgImage'.
 * @property range The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
 * @property spriteColumn Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
 * @property start The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
 * @property step The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
 * @property stretchMode The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
 * @property syncMode The Video Sync Mode
 */
public data class JpgImageResponse(
    public val keyFrameInterval: String? = null,
    public val label: String? = null,
    public val layers: List<JpgLayerResponse>? = null,
    public val odataType: String,
    public val range: String? = null,
    public val spriteColumn: Int? = null,
    public val start: String,
    public val step: String? = null,
    public val stretchMode: String? = null,
    public val syncMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.JpgImageResponse): JpgImageResponse = JpgImageResponse(
            keyFrameInterval = javaType.keyFrameInterval().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            layers = javaType.layers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.JpgLayerResponse.Companion.toKotlin(args0)
                })
            }),
            odataType = javaType.odataType(),
            range = javaType.range().map({ args0 -> args0 }).orElse(null),
            spriteColumn = javaType.spriteColumn().map({ args0 -> args0 }).orElse(null),
            start = javaType.start(),
            step = javaType.step().map({ args0 -> args0 }).orElse(null),
            stretchMode = javaType.stretchMode().map({ args0 -> args0 }).orElse(null),
            syncMode = javaType.syncMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
