@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property currentKeyIdentifier The current key used to encrypt the Media Services account, including the key version.
 * @property keyIdentifier The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
 */
public data class KeyVaultPropertiesResponse(
    public val currentKeyIdentifier: String,
    public val keyIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            currentKeyIdentifier = javaType.currentKeyIdentifier(),
            keyIdentifier = javaType.keyIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
