@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class of response for listPaths action
 * @property downloadPaths Download Paths supported by current Streaming Locator
 * @property streamingPaths Streaming Paths supported by current Streaming Locator
 */
public data class ListStreamingLocatorPathsResult(
    public val downloadPaths: List<String>? = null,
    public val streamingPaths: List<StreamingPathResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ListStreamingLocatorPathsResult): ListStreamingLocatorPathsResult = ListStreamingLocatorPathsResult(
            downloadPaths = javaType.downloadPaths().map({ args0 -> args0 }),
            streamingPaths = javaType.streamingPaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingPathResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
