@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The live event ingest interruption data.
 * @property begin UTC time of interruption start, encoder disconnected.
 * @property duration Duration of interruption in ISO 8601 time. For example, use PT1H30M to indicate 1 hour and 30 minutes.
 * @property end UTC time of interruption end, encoder re-connected.
 * @property reason Interruption reason.
 */
public data class LiveEventIngestInterruptionResponse(
    public val begin: String? = null,
    public val duration: String? = null,
    public val end: String? = null,
    public val reason: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventIngestInterruptionResponse): LiveEventIngestInterruptionResponse = LiveEventIngestInterruptionResponse(
            begin = javaType.begin().map({ args0 -> args0 }).orElse(null),
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            end = javaType.end().map({ args0 -> args0 }).orElse(null),
            reason = javaType.reason().map({ args0 -> args0 }).orElse(null),
        )
    }
}
