@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
 * @property trackName The output track name. This property is reserved for future use, any value set on this property will be ignored.
 */
public data class LiveEventOutputTranscriptionTrackResponse(
    public val trackName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventOutputTranscriptionTrackResponse): LiveEventOutputTranscriptionTrackResponse = LiveEventOutputTranscriptionTrackResponse(
            trackName = javaType.trackName(),
        )
    }
}
