@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Live event preview settings.
 * @property accessControl The access control for live event preview.
 * @property alternativeMediaId An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
 * @property endpoints The endpoints for preview. Do not share the preview URL with the live event audience.
 * @property previewLocator The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
 * @property streamingPolicyName The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
 */
public data class LiveEventPreviewResponse(
    public val accessControl: LiveEventPreviewAccessControlResponse? = null,
    public val alternativeMediaId: String? = null,
    public val endpoints: List<LiveEventEndpointResponse>? = null,
    public val previewLocator: String? = null,
    public val streamingPolicyName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventPreviewResponse): LiveEventPreviewResponse = LiveEventPreviewResponse(
            accessControl = javaType.accessControl().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventPreviewAccessControlResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            alternativeMediaId = javaType.alternativeMediaId().map({ args0 -> args0 }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            previewLocator = javaType.previewLocator().map({ args0 -> args0 }).orElse(null),
            streamingPolicyName = javaType.streamingPolicyName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
