@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The live event stream event data.
 * @property bitrate Bitrate of the track.
 * @property currentFragmentTimestamp Current fragment timestamp in timescale.
 * @property discontinuityGap Length of the discontinuity gap in timescale.
 * @property duration Fragment duration.
 * @property fragmentDropReason Reason the fragment was dropped.
 * @property fragmentOneDuration Duration of first fragment used to make a comparison, in timescale.
 * @property fragmentOneTimestamp Timestamp of first fragment used to make a comparison, in timescale.
 * @property fragmentTwoDuration Duration of second fragment used to make a comparison, in timescale.
 * @property fragmentTwoTimestamp Timestamp of second fragment used to make a comparison, in timescale.
 * @property maxTime The larger timestamp of the two fragments compared.
 * @property maxTimeMediaType The media type of the larger timestamp of two fragments compared.
 * @property mediaTimestamp Fragment timestamp in timescale.
 * @property mediaType Type of the track.
 * @property minTime The smaller timestamp of the two fragments compared.
 * @property minTimeMediaType The media type of the smaller timestamp of two fragments compared.
 * @property previousFragmentDuration Previous fragment duration in timescale.
 * @property previousFragmentTimestamp Previous fragment timestamp in timescale.
 * @property remoteIp Truncated IP of the encoder.
 * @property remotePort Port of the encoder.
 * @property resolution Width x Height for video, null otherwise.
 * @property resultCode Result code.
 * @property resultMessage Result message.
 * @property streamId Stream ID in the format "trackName_bitrate"
 * @property streamName Identifier of the stream or connection. Encoder or customer is responsible to add this ID in the ingest URL.
 * @property timescale Timescale in which timestamps are expressed.
 * @property timescaleOfMaxTime Timescale of the fragment with the larger timestamp.
 * @property timescaleOfMinTime Timescale of the fragment with the smaller timestamp.
 * @property trackId Track index.
 * @property trackName Name of the track.
 */
public data class LiveEventStreamEventDataResponse(
    public val bitrate: Double? = null,
    public val currentFragmentTimestamp: String? = null,
    public val discontinuityGap: Double? = null,
    public val duration: String? = null,
    public val fragmentDropReason: String? = null,
    public val fragmentOneDuration: String? = null,
    public val fragmentOneTimestamp: String? = null,
    public val fragmentTwoDuration: String? = null,
    public val fragmentTwoTimestamp: String? = null,
    public val maxTime: String? = null,
    public val maxTimeMediaType: String? = null,
    public val mediaTimestamp: String? = null,
    public val mediaType: String? = null,
    public val minTime: String? = null,
    public val minTimeMediaType: String? = null,
    public val previousFragmentDuration: String? = null,
    public val previousFragmentTimestamp: String? = null,
    public val remoteIp: String? = null,
    public val remotePort: String? = null,
    public val resolution: String? = null,
    public val resultCode: String? = null,
    public val resultMessage: String? = null,
    public val streamId: String? = null,
    public val streamName: String? = null,
    public val timescale: String? = null,
    public val timescaleOfMaxTime: String? = null,
    public val timescaleOfMinTime: String? = null,
    public val trackId: Int? = null,
    public val trackName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventStreamEventDataResponse): LiveEventStreamEventDataResponse = LiveEventStreamEventDataResponse(
            bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
            currentFragmentTimestamp = javaType.currentFragmentTimestamp().map({ args0 -> args0 }).orElse(null),
            discontinuityGap = javaType.discontinuityGap().map({ args0 -> args0 }).orElse(null),
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            fragmentDropReason = javaType.fragmentDropReason().map({ args0 -> args0 }).orElse(null),
            fragmentOneDuration = javaType.fragmentOneDuration().map({ args0 -> args0 }).orElse(null),
            fragmentOneTimestamp = javaType.fragmentOneTimestamp().map({ args0 -> args0 }).orElse(null),
            fragmentTwoDuration = javaType.fragmentTwoDuration().map({ args0 -> args0 }).orElse(null),
            fragmentTwoTimestamp = javaType.fragmentTwoTimestamp().map({ args0 -> args0 }).orElse(null),
            maxTime = javaType.maxTime().map({ args0 -> args0 }).orElse(null),
            maxTimeMediaType = javaType.maxTimeMediaType().map({ args0 -> args0 }).orElse(null),
            mediaTimestamp = javaType.mediaTimestamp().map({ args0 -> args0 }).orElse(null),
            mediaType = javaType.mediaType().map({ args0 -> args0 }).orElse(null),
            minTime = javaType.minTime().map({ args0 -> args0 }).orElse(null),
            minTimeMediaType = javaType.minTimeMediaType().map({ args0 -> args0 }).orElse(null),
            previousFragmentDuration = javaType.previousFragmentDuration().map({ args0 -> args0 }).orElse(null),
            previousFragmentTimestamp = javaType.previousFragmentTimestamp().map({ args0 ->
                args0
            }).orElse(null),
            remoteIp = javaType.remoteIp().map({ args0 -> args0 }).orElse(null),
            remotePort = javaType.remotePort().map({ args0 -> args0 }).orElse(null),
            resolution = javaType.resolution().map({ args0 -> args0 }).orElse(null),
            resultCode = javaType.resultCode().map({ args0 -> args0 }).orElse(null),
            resultMessage = javaType.resultMessage().map({ args0 -> args0 }).orElse(null),
            streamId = javaType.streamId().map({ args0 -> args0 }).orElse(null),
            streamName = javaType.streamName().map({ args0 -> args0 }).orElse(null),
            timescale = javaType.timescale().map({ args0 -> args0 }).orElse(null),
            timescaleOfMaxTime = javaType.timescaleOfMaxTime().map({ args0 -> args0 }).orElse(null),
            timescaleOfMinTime = javaType.timescaleOfMinTime().map({ args0 -> args0 }).orElse(null),
            trackId = javaType.trackId().map({ args0 -> args0 }).orElse(null),
            trackName = javaType.trackName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
