@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The live event stream event.
 * @property data Event data based on event type.
 * @property eventLevel Event level.
 * @property eventTime The time event raised.
 * @property eventType The type of the stream event. Format: StreamEvent/{eventType}
 */
public data class LiveEventStreamEventResponse(
    public val `data`: LiveEventStreamEventDataResponse? = null,
    public val eventLevel: String? = null,
    public val eventTime: String? = null,
    public val eventType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventStreamEventResponse): LiveEventStreamEventResponse = LiveEventStreamEventResponse(
            `data` = javaType.`data`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventStreamEventDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventLevel = javaType.eventLevel().map({ args0 -> args0 }).orElse(null),
            eventTime = javaType.eventTime().map({ args0 -> args0 }).orElse(null),
            eventType = javaType.eventType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
