@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
 * @property inputTrackSelection Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
 * @property language Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
 * @property outputTranscriptionTrack Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
 */
public data class LiveEventTranscriptionResponse(
    public val inputTrackSelection: List<LiveEventInputTrackSelectionResponse>? = null,
    public val language: String? = null,
    public val outputTranscriptionTrack: LiveEventOutputTranscriptionTrackResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventTranscriptionResponse): LiveEventTranscriptionResponse = LiveEventTranscriptionResponse(
            inputTrackSelection = javaType.inputTrackSelection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventInputTrackSelectionResponse.Companion.toKotlin(args0)
                })
            }),
            language = javaType.language().map({ args0 -> args0 }).orElse(null),
            outputTranscriptionTrack = javaType.outputTranscriptionTrack().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventOutputTranscriptionTrackResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
