@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A list of PEM formatted certificates.
 * @property certificates PEM formatted public certificates, one per entry.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphPemCertificateList'.
 */
public data class MediaGraphPemCertificateListResponse(
    public val certificates: List<String>,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.MediaGraphPemCertificateListResponse): MediaGraphPemCertificateListResponse = MediaGraphPemCertificateListResponse(
            certificates = javaType.certificates().map({ args0 -> args0 }),
            odataType = javaType.odataType(),
        )
    }
}
