@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * RTSP source.
 * @property endpoint RTSP endpoint of the stream being connected to.
 * @property name Source name.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphRtspSource'.
 * @property transport Underlying RTSP transport. This can be used to enable or disable HTTP tunneling.
 */
public data class MediaGraphRtspSourceResponse(
    public val endpoint: Either<MediaGraphClearEndpointResponse, MediaGraphTlsEndpointResponse>,
    public val name: String,
    public val odataType: String,
    public val transport: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.MediaGraphRtspSourceResponse): MediaGraphRtspSourceResponse = MediaGraphRtspSourceResponse(
            endpoint = javaType.endpoint().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.media.kotlin.outputs.MediaGraphClearEndpointResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.media.kotlin.outputs.MediaGraphTlsEndpointResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            name = javaType.name(),
            odataType = javaType.odataType(),
            transport = javaType.transport(),
        )
    }
}
