@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Options for controlling the authentication of TLS endpoints.
 * @property ignoreHostname Ignore the host name (common name) during validation.
 * @property ignoreSignature Ignore the integrity of the certificate chain at the current time.
 */
public data class MediaGraphTlsValidationOptionsResponse(
    public val ignoreHostname: Boolean,
    public val ignoreSignature: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.MediaGraphTlsValidationOptionsResponse): MediaGraphTlsValidationOptionsResponse = MediaGraphTlsValidationOptionsResponse(
            ignoreHostname = javaType.ignoreHostname(),
            ignoreSignature = javaType.ignoreSignature(),
        )
    }
}
