@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Username/password credential pair.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphUsernamePasswordCredentials'.
 * @property password Password for a username/password pair.
 * @property username Username for a username/password pair.
 */
public data class MediaGraphUsernamePasswordCredentialsResponse(
    public val odataType: String,
    public val password: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.MediaGraphUsernamePasswordCredentialsResponse): MediaGraphUsernamePasswordCredentialsResponse =
            MediaGraphUsernamePasswordCredentialsResponse(
                odataType = javaType.odataType(),
                password = javaType.password(),
                username = javaType.username(),
            )
    }
}
