@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents an output file produced.
 * @property labels The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
 */
public data class OutputFileResponse(
    public val labels: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.OutputFileResponse): OutputFileResponse = OutputFileResponse(
            labels = javaType.labels().map({ args0 -> args0 }),
        )
    }
}
