@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Select audio tracks from the input by specifying an attribute and an attribute filter.
 * @property attribute The TrackAttribute to filter the tracks by.
 * @property channelMapping Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
 * @property filter The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
 * @property filterValue The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
 */
public data class SelectAudioTrackByAttributeResponse(
    public val attribute: String,
    public val channelMapping: String? = null,
    public val filter: String,
    public val filterValue: String? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.SelectAudioTrackByAttributeResponse): SelectAudioTrackByAttributeResponse = SelectAudioTrackByAttributeResponse(
            attribute = javaType.attribute(),
            channelMapping = javaType.channelMapping().map({ args0 -> args0 }).orElse(null),
            filter = javaType.filter(),
            filterValue = javaType.filterValue().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
