@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Select audio tracks from the input by specifying a track identifier.
 * @property channelMapping Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.SelectAudioTrackById'.
 * @property trackId Track identifier to select
 */
public data class SelectAudioTrackByIdResponse(
    public val channelMapping: String? = null,
    public val odataType: String,
    public val trackId: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.SelectAudioTrackByIdResponse): SelectAudioTrackByIdResponse = SelectAudioTrackByIdResponse(
            channelMapping = javaType.channelMapping().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            trackId = javaType.trackId(),
        )
    }
}
