@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes all the settings to be used when encoding the input video with the Standard Encoder.
 * @property codecs The list of codecs to be used when encoding the input video.
 * @property experimentalOptions Dictionary containing key value pairs for parameters not exposed in the preset itself
 * @property filters One or more filtering operations that are applied to the input media before encoding.
 * @property formats The list of outputs to be produced by the encoder.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.StandardEncoderPreset'.
 */
public data class StandardEncoderPresetResponse(
    public val codecs: List<Any>,
    public val experimentalOptions: Map<String, String>? = null,
    public val filters: FiltersResponse? = null,
    public val formats: List<Any>,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.StandardEncoderPresetResponse): StandardEncoderPresetResponse = StandardEncoderPresetResponse(
            codecs = javaType.codecs().map({ args0 -> args0 }),
            experimentalOptions = javaType.experimentalOptions().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.FiltersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            formats = javaType.formats().map({ args0 -> args0 }),
            odataType = javaType.odataType(),
        )
    }
}
