@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The storage account details.
 * @property id The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
 * @property identity The storage account identity.
 * @property status The current status of the storage account mapping.
 * @property type The type of the storage account.
 */
public data class StorageAccountResponse(
    public val id: String? = null,
    public val identity: ResourceIdentityResponse? = null,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.StorageAccountResponse): StorageAccountResponse = StorageAccountResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
