@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Suppress

/**
 * Streaming endpoint access control definition.
 * @property akamai The access control of Akamai
 * @property ip The IP access control of the streaming endpoint.
 */
public data class StreamingEndpointAccessControlResponse(
    public val akamai: AkamaiAccessControlResponse? = null,
    public val ip: IPAccessControlResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.StreamingEndpointAccessControlResponse): StreamingEndpointAccessControlResponse = StreamingEndpointAccessControlResponse(
            akamai = javaType.akamai().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.AkamaiAccessControlResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ip = javaType.ip().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.IPAccessControlResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
