@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class to specify properties of content key
 * @property label Label can be used to specify Content Key when creating a Streaming Locator
 * @property policyName Policy used by Content Key
 * @property tracks Tracks which use this content key
 */
public data class StreamingPolicyContentKeyResponse(
    public val label: String? = null,
    public val policyName: String? = null,
    public val tracks: List<TrackSelectionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.StreamingPolicyContentKeyResponse): StreamingPolicyContentKeyResponse = StreamingPolicyContentKeyResponse(
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
            tracks = javaType.tracks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.TrackSelectionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
