@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Class to specify configurations of FairPlay in Streaming Policy
 * @property allowPersistentLicense All license to be persistent or not
 * @property customLicenseAcquisitionUrlTemplate Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
 */
public data class StreamingPolicyFairPlayConfigurationResponse(
    public val allowPersistentLicense: Boolean,
    public val customLicenseAcquisitionUrlTemplate: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.StreamingPolicyFairPlayConfigurationResponse): StreamingPolicyFairPlayConfigurationResponse = StreamingPolicyFairPlayConfigurationResponse(
            allowPersistentLicense = javaType.allowPersistentLicense(),
            customLicenseAcquisitionUrlTemplate = javaType.customLicenseAcquisitionUrlTemplate().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
