@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of a TransformOutput, which are the rules to be applied while generating the desired output.
 * @property onError A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
 * @property preset Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
 * @property relativePriority Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
 */
public data class TransformOutputResponse(
    public val onError: String? = null,
    public val preset: Any,
    public val relativePriority: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.TransformOutputResponse): TransformOutputResponse = TransformOutputResponse(
            onError = javaType.onError().map({ args0 -> args0 }).orElse(null),
            preset = javaType.preset(),
            relativePriority = javaType.relativePriority().map({ args0 -> args0 }).orElse(null),
        )
    }
}
