@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs a JSON format file.
 * @property audioLanguage The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
 * @property experimentalOptions Dictionary containing key value pairs for parameters not exposed in the preset itself
 * @property insightsToExtract Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only, then only video insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio only. Your Jobs in such conditions would error out.
 * @property mode Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.VideoAnalyzerPreset'.
 */
public data class VideoAnalyzerPresetResponse(
    public val audioLanguage: String? = null,
    public val experimentalOptions: Map<String, String>? = null,
    public val insightsToExtract: String? = null,
    public val mode: String? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.VideoAnalyzerPresetResponse): VideoAnalyzerPresetResponse = VideoAnalyzerPresetResponse(
            audioLanguage = javaType.audioLanguage().map({ args0 -> args0 }).orElse(null),
            experimentalOptions = javaType.experimentalOptions().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            insightsToExtract = javaType.insightsToExtract().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
