@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of a video overlay.
 * @property audioGainLevel The gain level of audio in the overlay. The value should be in the range [0, 1&#46;0]. The default is 1.0.
 * @property cropRectangle An optional rectangular window used to crop the overlay image or video.
 * @property end The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
 * @property fadeInDuration The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
 * @property fadeOutDuration The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
 * @property inputLabel The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.VideoOverlay'.
 * @property opacity The opacity of the overlay. This is a value in the range [0 - 1&#46;0]. Default is 1.0 which mean the overlay is opaque.
 * @property position The location in the input video where the overlay is applied.
 * @property start The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
 */
public data class VideoOverlayResponse(
    public val audioGainLevel: Double? = null,
    public val cropRectangle: RectangleResponse? = null,
    public val end: String? = null,
    public val fadeInDuration: String? = null,
    public val fadeOutDuration: String? = null,
    public val inputLabel: String,
    public val odataType: String,
    public val opacity: Double? = null,
    public val position: RectangleResponse? = null,
    public val start: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.VideoOverlayResponse): VideoOverlayResponse = VideoOverlayResponse(
            audioGainLevel = javaType.audioGainLevel().map({ args0 -> args0 }).orElse(null),
            cropRectangle = javaType.cropRectangle().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.RectangleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            end = javaType.end().map({ args0 -> args0 }).orElse(null),
            fadeInDuration = javaType.fadeInDuration().map({ args0 -> args0 }).orElse(null),
            fadeOutDuration = javaType.fadeOutDuration().map({ args0 -> args0 }).orElse(null),
            inputLabel = javaType.inputLabel(),
            odataType = javaType.odataType(),
            opacity = javaType.opacity().map({ args0 -> args0 }).orElse(null),
            position = javaType.position().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.RectangleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            start = javaType.start().map({ args0 -> args0 }).orElse(null),
        )
    }
}
