@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A TrackSelection to select video tracks.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
 */
public data class VideoTrackDescriptorResponse(
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.VideoTrackDescriptorResponse): VideoTrackDescriptorResponse = VideoTrackDescriptorResponse(
            odataType = javaType.odataType(),
        )
    }
}
