@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.AksAssessmentOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.AKSAssessmentSettingsArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.AKSAssessmentSettingsArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.AssessmentScopeParametersArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.AssessmentScopeParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ARM model of AKS Assessment.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### AksAssessmentOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var aksAssessmentOperation = new AzureNative.Migrate.AksAssessmentOperation("aksAssessmentOperation", new()
 *     {
 *         AssessmentName = "testaksassessment",
 *         ProjectName = "testproject",
 *         ResourceGroupName = "rgaksswagger",
 *         Scope = new AzureNative.Migrate.Inputs.AssessmentScopeParametersArgs
 *         {
 *             ServerGroupId = "/subscriptions/D6F60DF4-CE70-4E39-8217-B8FBE7CA85AA/resourceGroups/rgaksswagger/providers/Microsoft.Migrate/assessmentProjects/testproject/groups/testgrp",
 *         },
 *         Settings = new AzureNative.Migrate.Inputs.AKSAssessmentSettingsArgs
 *         {
 *             AzureLocation = "Unknown",
 *             Category = AzureNative.Migrate.AzureVmCategory.All,
 *             Consolidation = AzureNative.Migrate.ConsolidationType.Full,
 *             Currency = AzureNative.Migrate.AzureCurrency.Unknown,
 *             DiscountPercentage = 15,
 *             EnvironmentType = AzureNative.Migrate.AzureEnvironmentType.Unknown,
 *             LicensingProgram = AzureNative.Migrate.LicensingProgram.Default,
 *             PerformanceData = new AzureNative.Migrate.Inputs.PerfDataSettingsArgs
 *             {
 *                 Percentile = AzureNative.Migrate.Percentile.Percentile50,
 *                 PerfDataEndTime = "2023-11-07T06:51:24.320Z",
 *                 PerfDataStartTime = "2023-11-07T06:51:24.320Z",
 *                 TimeRange = AzureNative.Migrate.TimeRange.Day,
 *             },
 *             PricingTier = AzureNative.Migrate.PricingTier.Standard,
 *             SavingsOptions = AzureNative.Migrate.SavingsOptions.None,
 *             ScalingFactor = 3,
 *             SizingCriteria = AzureNative.Migrate.AssessmentSizingCriterion.PerformanceBased,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAksAssessmentOperation(ctx, "aksAssessmentOperation", &migrate.AksAssessmentOperationArgs{
 * 			AssessmentName:    pulumi.String("testaksassessment"),
 * 			ProjectName:       pulumi.String("testproject"),
 * 			ResourceGroupName: pulumi.String("rgaksswagger"),
 * 			Scope: &migrate.AssessmentScopeParametersArgs{
 * 				ServerGroupId: pulumi.String("/subscriptions/D6F60DF4-CE70-4E39-8217-B8FBE7CA85AA/resourceGroups/rgaksswagger/providers/Microsoft.Migrate/assessmentProjects/testproject/groups/testgrp"),
 * 			},
 * 			Settings: &migrate.AKSAssessmentSettingsArgs{
 * 				AzureLocation:      pulumi.String("Unknown"),
 * 				Category:           pulumi.String(migrate.AzureVmCategoryAll),
 * 				Consolidation:      pulumi.String(migrate.ConsolidationTypeFull),
 * 				Currency:           pulumi.String(migrate.AzureCurrencyUnknown),
 * 				DiscountPercentage: pulumi.Float64(15),
 * 				EnvironmentType:    pulumi.String(migrate.AzureEnvironmentTypeUnknown),
 * 				LicensingProgram:   pulumi.String(migrate.LicensingProgramDefault),
 * 				PerformanceData: &migrate.PerfDataSettingsArgs{
 * 					Percentile:        pulumi.String(migrate.PercentilePercentile50),
 * 					PerfDataEndTime:   pulumi.String("2023-11-07T06:51:24.320Z"),
 * 					PerfDataStartTime: pulumi.String("2023-11-07T06:51:24.320Z"),
 * 					TimeRange:         pulumi.String(migrate.TimeRangeDay),
 * 				},
 * 				PricingTier:    pulumi.String(migrate.PricingTierStandard),
 * 				SavingsOptions: pulumi.String(migrate.SavingsOptionsNone),
 * 				ScalingFactor:  pulumi.Float64(3),
 * 				SizingCriteria: pulumi.String(migrate.AssessmentSizingCriterionPerformanceBased),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.AksAssessmentOperation;
 * import com.pulumi.azurenative.migrate.AksAssessmentOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.AssessmentScopeParametersArgs;
 * import com.pulumi.azurenative.migrate.inputs.AKSAssessmentSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.PerfDataSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var aksAssessmentOperation = new AksAssessmentOperation("aksAssessmentOperation", AksAssessmentOperationArgs.builder()
 *             .assessmentName("testaksassessment")
 *             .projectName("testproject")
 *             .resourceGroupName("rgaksswagger")
 *             .scope(AssessmentScopeParametersArgs.builder()
 *                 .serverGroupId("/subscriptions/D6F60DF4-CE70-4E39-8217-B8FBE7CA85AA/resourceGroups/rgaksswagger/providers/Microsoft.Migrate/assessmentProjects/testproject/groups/testgrp")
 *                 .build())
 *             .settings(AKSAssessmentSettingsArgs.builder()
 *                 .azureLocation("Unknown")
 *                 .category("All")
 *                 .consolidation("Full")
 *                 .currency("Unknown")
 *                 .discountPercentage(15)
 *                 .environmentType("Unknown")
 *                 .licensingProgram("Default")
 *                 .performanceData(PerfDataSettingsArgs.builder()
 *                     .percentile("Percentile50")
 *                     .perfDataEndTime("2023-11-07T06:51:24.320Z")
 *                     .perfDataStartTime("2023-11-07T06:51:24.320Z")
 *                     .timeRange("Day")
 *                     .build())
 *                 .pricingTier("Standard")
 *                 .savingsOptions("None")
 *                 .scalingFactor(3)
 *                 .sizingCriteria("PerformanceBased")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:AksAssessmentOperation testaksassessment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/aksAssessments/{assessmentName}
 * ```
 * @property assessmentName AKS Assessment Name.
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope Gets or sets scope parameters to identify inventory items for assessment.
 * @property settings Gets or sets AKS Assessment Settings.
 */
public data class AksAssessmentOperationArgs(
    public val assessmentName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<AssessmentScopeParametersArgs>? = null,
    public val settings: Output<AKSAssessmentSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.AksAssessmentOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.AksAssessmentOperationArgs =
        com.pulumi.azurenative.migrate.AksAssessmentOperationArgs.builder()
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AksAssessmentOperationArgs].
 */
@PulumiTagMarker
public class AksAssessmentOperationArgsBuilder internal constructor() {
    private var assessmentName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<AssessmentScopeParametersArgs>? = null

    private var settings: Output<AKSAssessmentSettingsArgs>? = null

    /**
     * @param value AKS Assessment Name.
     */
    @JvmName("iugvfytrubtpelxv")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("bnfdorycdndtsuon")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cddgvbitokhmmjgb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets scope parameters to identify inventory items for assessment.
     */
    @JvmName("nprcgfskkrpeoglr")
    public suspend fun scope(`value`: Output<AssessmentScopeParametersArgs>) {
        this.scope = value
    }

    /**
     * @param value Gets or sets AKS Assessment Settings.
     */
    @JvmName("cdidqqokdeeexxdp")
    public suspend fun settings(`value`: Output<AKSAssessmentSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value AKS Assessment Name.
     */
    @JvmName("tefnkrosfdbjblgy")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("lcmvhhbnapoqosdf")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xsihgxqegatawxhv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets scope parameters to identify inventory items for assessment.
     */
    @JvmName("dwbepvjdufnvllcs")
    public suspend fun scope(`value`: AssessmentScopeParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument Gets or sets scope parameters to identify inventory items for assessment.
     */
    @JvmName("fvovbdpodsubbupa")
    public suspend fun scope(argument: suspend AssessmentScopeParametersArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentScopeParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value Gets or sets AKS Assessment Settings.
     */
    @JvmName("jhufjiawnrkiieab")
    public suspend fun settings(`value`: AKSAssessmentSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Gets or sets AKS Assessment Settings.
     */
    @JvmName("tgmmnpcsejdegtpg")
    public suspend fun settings(argument: suspend AKSAssessmentSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AKSAssessmentSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    internal fun build(): AksAssessmentOperationArgs = AksAssessmentOperationArgs(
        assessmentName = assessmentName,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        scope = scope,
        settings = settings,
    )
}
