@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.AssessmentProjectsOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ProjectStatus
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Assessment project site resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### AssessmentProjectsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessmentProjectsOperation = new AzureNative.Migrate.AssessmentProjectsOperation("assessmentProjectsOperation", new()
 *     {
 *         AssessmentSolutionId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa",
 *         CustomerStorageAccountArmId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa",
 *         Location = "southeastasia",
 *         ProjectName = "sakanwar1204project",
 *         ProjectStatus = AzureNative.Migrate.ProjectStatus.Active,
 *         ProvisioningState = AzureNative.Migrate.ProvisioningState.Succeeded,
 *         PublicNetworkAccess = "Disabled",
 *         ResourceGroupName = "sakanwar",
 *         Tags =
 *         {
 *             { "Migrate Project", "sakanwar-PE-SEA" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAssessmentProjectsOperation(ctx, "assessmentProjectsOperation", &migrate.AssessmentProjectsOperationArgs{
 * 			AssessmentSolutionId:        pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa"),
 * 			CustomerStorageAccountArmId: pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa"),
 * 			Location:                    pulumi.String("southeastasia"),
 * 			ProjectName:                 pulumi.String("sakanwar1204project"),
 * 			ProjectStatus:               pulumi.String(migrate.ProjectStatusActive),
 * 			ProvisioningState:           pulumi.String(migrate.ProvisioningStateSucceeded),
 * 			PublicNetworkAccess:         pulumi.String("Disabled"),
 * 			ResourceGroupName:           pulumi.String("sakanwar"),
 * 			Tags: pulumi.StringMap{
 * 				"Migrate Project": pulumi.String("sakanwar-PE-SEA"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.AssessmentProjectsOperation;
 * import com.pulumi.azurenative.migrate.AssessmentProjectsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessmentProjectsOperation = new AssessmentProjectsOperation("assessmentProjectsOperation", AssessmentProjectsOperationArgs.builder()
 *             .assessmentSolutionId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa")
 *             .customerStorageAccountArmId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa")
 *             .location("southeastasia")
 *             .projectName("sakanwar1204project")
 *             .projectStatus("Active")
 *             .provisioningState("Succeeded")
 *             .publicNetworkAccess("Disabled")
 *             .resourceGroupName("sakanwar")
 *             .tags(Map.of("Migrate Project", "sakanwar-PE-SEA"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:AssessmentProjectsOperation sakanwar1204project /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}
 * ```
 * @property assessmentSolutionId Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
 * @property customerStorageAccountArmId The ARM id of the storage account used for interactions when public access is
 * disabled.
 * @property customerWorkspaceId The ARM id of service map workspace created by customer.
 * @property customerWorkspaceLocation Location of service map workspace created by customer.
 * @property location The geo-location where the resource lives
 * @property projectName Assessment Project Name
 * @property projectStatus Assessment project status.
 * @property provisioningState The status of the last operation.
 * @property publicNetworkAccess This value can be set to 'enabled' to avoid breaking changes on existing
 * customer resources and templates. If set to 'disabled', traffic over public
 * interface is not allowed, and private endpoint connections would be the
 * exclusive access method.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AssessmentProjectsOperationArgs(
    public val assessmentSolutionId: Output<String>? = null,
    public val customerStorageAccountArmId: Output<String>? = null,
    public val customerWorkspaceId: Output<String>? = null,
    public val customerWorkspaceLocation: Output<String>? = null,
    public val location: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val projectStatus: Output<Either<String, ProjectStatus>>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.AssessmentProjectsOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.AssessmentProjectsOperationArgs =
        com.pulumi.azurenative.migrate.AssessmentProjectsOperationArgs.builder()
            .assessmentSolutionId(assessmentSolutionId?.applyValue({ args0 -> args0 }))
            .customerStorageAccountArmId(customerStorageAccountArmId?.applyValue({ args0 -> args0 }))
            .customerWorkspaceId(customerWorkspaceId?.applyValue({ args0 -> args0 }))
            .customerWorkspaceLocation(customerWorkspaceLocation?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .projectStatus(
                projectStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AssessmentProjectsOperationArgs].
 */
@PulumiTagMarker
public class AssessmentProjectsOperationArgsBuilder internal constructor() {
    private var assessmentSolutionId: Output<String>? = null

    private var customerStorageAccountArmId: Output<String>? = null

    private var customerWorkspaceId: Output<String>? = null

    private var customerWorkspaceLocation: Output<String>? = null

    private var location: Output<String>? = null

    private var projectName: Output<String>? = null

    private var projectStatus: Output<Either<String, ProjectStatus>>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
     */
    @JvmName("ylbfrpelffycgagy")
    public suspend fun assessmentSolutionId(`value`: Output<String>) {
        this.assessmentSolutionId = value
    }

    /**
     * @param value The ARM id of the storage account used for interactions when public access is
     * disabled.
     */
    @JvmName("jaoewihxtpyidkfx")
    public suspend fun customerStorageAccountArmId(`value`: Output<String>) {
        this.customerStorageAccountArmId = value
    }

    /**
     * @param value The ARM id of service map workspace created by customer.
     */
    @JvmName("mqvvlnxakqmipbsi")
    public suspend fun customerWorkspaceId(`value`: Output<String>) {
        this.customerWorkspaceId = value
    }

    /**
     * @param value Location of service map workspace created by customer.
     */
    @JvmName("lrxtqibokwouhwxh")
    public suspend fun customerWorkspaceLocation(`value`: Output<String>) {
        this.customerWorkspaceLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xvtmtofnnyaltcjf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("xxxrrnuwfjmkhqao")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Assessment project status.
     */
    @JvmName("hflfdelnvswnevtb")
    public suspend fun projectStatus(`value`: Output<Either<String, ProjectStatus>>) {
        this.projectStatus = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("fqjitoajecrmduex")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value This value can be set to 'enabled' to avoid breaking changes on existing
     * customer resources and templates. If set to 'disabled', traffic over public
     * interface is not allowed, and private endpoint connections would be the
     * exclusive access method.
     */
    @JvmName("jrbcyhkwkniuocna")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xrnsndihqoywgkog")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tunwjgansyfihnaa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
     */
    @JvmName("fvheiaxevrgkooie")
    public suspend fun assessmentSolutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentSolutionId = mapped
    }

    /**
     * @param value The ARM id of the storage account used for interactions when public access is
     * disabled.
     */
    @JvmName("yicrlscrldawcpla")
    public suspend fun customerStorageAccountArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerStorageAccountArmId = mapped
    }

    /**
     * @param value The ARM id of service map workspace created by customer.
     */
    @JvmName("akgkyfcqqpklurfc")
    public suspend fun customerWorkspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerWorkspaceId = mapped
    }

    /**
     * @param value Location of service map workspace created by customer.
     */
    @JvmName("plxxknoypvtixkva")
    public suspend fun customerWorkspaceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerWorkspaceLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jsjkjxcmlsxitfnf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("xirvrfrybouiltcf")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Assessment project status.
     */
    @JvmName("jwytiksusxglhtvd")
    public suspend fun projectStatus(`value`: Either<String, ProjectStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectStatus = mapped
    }

    /**
     * @param value Assessment project status.
     */
    @JvmName("hwsvkygedpxxmvuh")
    public fun projectStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProjectStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectStatus = mapped
    }

    /**
     * @param value Assessment project status.
     */
    @JvmName("liajysmnessseotk")
    public fun projectStatus(`value`: ProjectStatus) {
        val toBeMapped = Either.ofRight<String, ProjectStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectStatus = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("nxmctrrfquhgoqqm")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("tofhrjfyhwrviqbt")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("vkxululykliengtr")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value This value can be set to 'enabled' to avoid breaking changes on existing
     * customer resources and templates. If set to 'disabled', traffic over public
     * interface is not allowed, and private endpoint connections would be the
     * exclusive access method.
     */
    @JvmName("ilwkvacnulqwcqtt")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cajdvhrbrgycbyls")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ushfjfbpapcmvmid")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rdamevkalxtwfbcy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AssessmentProjectsOperationArgs = AssessmentProjectsOperationArgs(
        assessmentSolutionId = assessmentSolutionId,
        customerStorageAccountArmId = customerStorageAccountArmId,
        customerWorkspaceId = customerWorkspaceId,
        customerWorkspaceLocation = customerWorkspaceLocation,
        location = location,
        projectName = projectName,
        projectStatus = projectStatus,
        provisioningState = provisioningState,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
