@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.AssessmentsOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentSizingCriterion
import com.pulumi.azurenative.migrate.kotlin.enums.AzureCurrency
import com.pulumi.azurenative.migrate.kotlin.enums.AzureDiskType
import com.pulumi.azurenative.migrate.kotlin.enums.AzureHybridUseBenefit
import com.pulumi.azurenative.migrate.kotlin.enums.AzureOfferCode
import com.pulumi.azurenative.migrate.kotlin.enums.AzurePricingTier
import com.pulumi.azurenative.migrate.kotlin.enums.AzureReservedInstance
import com.pulumi.azurenative.migrate.kotlin.enums.AzureStorageRedundancy
import com.pulumi.azurenative.migrate.kotlin.enums.AzureVmFamily
import com.pulumi.azurenative.migrate.kotlin.enums.Percentile
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.migrate.kotlin.enums.TimeRange
import com.pulumi.azurenative.migrate.kotlin.inputs.VmUptimeArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.VmUptimeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Machine assessment resource.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-03-15.
 * ## Example Usage
 * ### AssessmentsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessmentsOperation = new AzureNative.Migrate.AssessmentsOperation("assessmentsOperation", new()
 *     {
 *         AssessmentName = "asm1",
 *         AzureDiskTypes = new[]
 *         {
 *             AzureNative.Migrate.AzureDiskType.Premium,
 *             AzureNative.Migrate.AzureDiskType.StandardSSD,
 *         },
 *         AzureHybridUseBenefit = AzureNative.Migrate.AzureHybridUseBenefit.Unknown,
 *         AzureLocation = "njxbwdtsxzhichsnk",
 *         AzureOfferCode = AzureNative.Migrate.AzureOfferCode.Unknown,
 *         AzurePricingTier = AzureNative.Migrate.AzurePricingTier.Standard,
 *         AzureStorageRedundancy = AzureNative.Migrate.AzureStorageRedundancy.Unknown,
 *         AzureVmFamilies = new[]
 *         {
 *             AzureNative.Migrate.AzureVmFamily.DSeries,
 *             AzureNative.Migrate.AzureVmFamily.Lsv2Series,
 *             AzureNative.Migrate.AzureVmFamily.MSeries,
 *             AzureNative.Migrate.AzureVmFamily.Mdsv2Series,
 *             AzureNative.Migrate.AzureVmFamily.Msv2Series,
 *             AzureNative.Migrate.AzureVmFamily.Mv2Series,
 *         },
 *         Currency = AzureNative.Migrate.AzureCurrency.Unknown,
 *         DiscountPercentage = 6,
 *         EaSubscriptionId = "kwsu",
 *         GroupName = "kuchatur-test",
 *         LinuxAzureHybridUseBenefit = AzureNative.Migrate.AzureHybridUseBenefit.Unknown,
 *         Percentile = AzureNative.Migrate.Percentile.Percentile50,
 *         PerfDataEndTime = "2023-09-26T09:36:48.491Z",
 *         PerfDataStartTime = "2023-09-26T09:36:48.491Z",
 *         ProjectName = "app18700project",
 *         ProvisioningState = AzureNative.Migrate.ProvisioningState.Succeeded,
 *         ReservedInstance = AzureNative.Migrate.AzureReservedInstance.None,
 *         ResourceGroupName = "ayagrawrg",
 *         ScalingFactor = 24,
 *         SizingCriterion = AzureNative.Migrate.AssessmentSizingCriterion.PerformanceBased,
 *         TimeRange = AzureNative.Migrate.TimeRange.Day,
 *         VmUptime = new AzureNative.Migrate.Inputs.VmUptimeArgs
 *         {
 *             DaysPerMonth = 13,
 *             HoursPerDay = 26,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAssessmentsOperation(ctx, "assessmentsOperation", &migrate.AssessmentsOperationArgs{
 * 			AssessmentName: pulumi.String("asm1"),
 * 			AzureDiskTypes: pulumi.StringArray{
 * 				pulumi.String(migrate.AzureDiskTypePremium),
 * 				pulumi.String(migrate.AzureDiskTypeStandardSSD),
 * 			},
 * 			AzureHybridUseBenefit:  pulumi.String(migrate.AzureHybridUseBenefitUnknown),
 * 			AzureLocation:          pulumi.String("njxbwdtsxzhichsnk"),
 * 			AzureOfferCode:         pulumi.String(migrate.AzureOfferCodeUnknown),
 * 			AzurePricingTier:       pulumi.String(migrate.AzurePricingTierStandard),
 * 			AzureStorageRedundancy: pulumi.String(migrate.AzureStorageRedundancyUnknown),
 * 			AzureVmFamilies: pulumi.StringArray{
 * 				pulumi.String(migrate.AzureVmFamilyDSeries),
 * 				pulumi.String(migrate.AzureVmFamilyLsv2Series),
 * 				pulumi.String(migrate.AzureVmFamilyMSeries),
 * 				pulumi.String(migrate.AzureVmFamilyMdsv2Series),
 * 				pulumi.String(migrate.AzureVmFamilyMsv2Series),
 * 				pulumi.String(migrate.AzureVmFamilyMv2Series),
 * 			},
 * 			Currency:                   pulumi.String(migrate.AzureCurrencyUnknown),
 * 			DiscountPercentage:         pulumi.Float64(6),
 * 			EaSubscriptionId:           pulumi.String("kwsu"),
 * 			GroupName:                  pulumi.String("kuchatur-test"),
 * 			LinuxAzureHybridUseBenefit: pulumi.String(migrate.AzureHybridUseBenefitUnknown),
 * 			Percentile:                 pulumi.String(migrate.PercentilePercentile50),
 * 			PerfDataEndTime:            pulumi.String("2023-09-26T09:36:48.491Z"),
 * 			PerfDataStartTime:          pulumi.String("2023-09-26T09:36:48.491Z"),
 * 			ProjectName:                pulumi.String("app18700project"),
 * 			ProvisioningState:          pulumi.String(migrate.ProvisioningStateSucceeded),
 * 			ReservedInstance:           pulumi.String(migrate.AzureReservedInstanceNone),
 * 			ResourceGroupName:          pulumi.String("ayagrawrg"),
 * 			ScalingFactor:              pulumi.Float64(24),
 * 			SizingCriterion:            pulumi.String(migrate.AssessmentSizingCriterionPerformanceBased),
 * 			TimeRange:                  pulumi.String(migrate.TimeRangeDay),
 * 			VmUptime: &migrate.VmUptimeArgs{
 * 				DaysPerMonth: pulumi.Float64(13),
 * 				HoursPerDay:  pulumi.Float64(26),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.AssessmentsOperation;
 * import com.pulumi.azurenative.migrate.AssessmentsOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.VmUptimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessmentsOperation = new AssessmentsOperation("assessmentsOperation", AssessmentsOperationArgs.builder()
 *             .assessmentName("asm1")
 *             .azureDiskTypes(
 *                 "Premium",
 *                 "StandardSSD")
 *             .azureHybridUseBenefit("Unknown")
 *             .azureLocation("njxbwdtsxzhichsnk")
 *             .azureOfferCode("Unknown")
 *             .azurePricingTier("Standard")
 *             .azureStorageRedundancy("Unknown")
 *             .azureVmFamilies(
 *                 "D_series",
 *                 "Lsv2_series",
 *                 "M_series",
 *                 "Mdsv2_series",
 *                 "Msv2_series",
 *                 "Mv2_series")
 *             .currency("Unknown")
 *             .discountPercentage(6)
 *             .eaSubscriptionId("kwsu")
 *             .groupName("kuchatur-test")
 *             .linuxAzureHybridUseBenefit("Unknown")
 *             .percentile("Percentile50")
 *             .perfDataEndTime("2023-09-26T09:36:48.491Z")
 *             .perfDataStartTime("2023-09-26T09:36:48.491Z")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .reservedInstance("None")
 *             .resourceGroupName("ayagrawrg")
 *             .scalingFactor(24)
 *             .sizingCriterion("PerformanceBased")
 *             .timeRange("Day")
 *             .vmUptime(VmUptimeArgs.builder()
 *                 .daysPerMonth(13)
 *                 .hoursPerDay(26)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:AssessmentsOperation asm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessments/{assessmentName}
 * ```
 * @property assessmentName Machine Assessment ARM name
 * @property azureDiskTypes Gets or sets the azure storage type. Premium, Standard etc.
 * @property azureHybridUseBenefit Gets or sets the user configurable setting to display the azure hybrid use
 * benefit.
 * @property azureLocation Azure Location or Azure region where to which the machines will be migrated.
 * @property azureOfferCode Azure Offer Code.
 * @property azurePricingTier Gets or sets Azure Pricing Tier - Free, Basic, etc.
 * @property azureStorageRedundancy Gets or sets the Azure Storage Redundancy. Example: Locally Redundant Storage.
 * @property azureVmFamilies Gets or sets the Azure VM families.
 * @property currency Currency in which prices should be reported.
 * @property discountPercentage Custom discount percentage.
 * @property eaSubscriptionId Gets or sets enterprise agreement subscription id.
 * @property groupName Group ARM name
 * @property linuxAzureHybridUseBenefit Gets or sets the user configurable setting to display the linux azure hybrid use
 * benefit.
 * @property percentile Percentile of the utilization data values to be considered while assessing
 * machines.
 * @property perfDataEndTime Gets or sets the end time to consider performance data for assessment.
 * @property perfDataStartTime Gets or sets the start time to consider performance data for assessment.
 * @property projectName Assessment Project Name
 * @property provisioningState The status of the last operation.
 * @property reservedInstance Gets or sets the Azure Reserved Instance - 1-Year, 3-Year.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalingFactor Percentage of buffer that user wants on performance metrics when recommending
 * Azure sizes.
 * @property sizingCriterion Assessment sizing criterion.
 * @property timeRange Time Range for which the historic utilization data should be considered for
 * assessment.
 * @property vmUptime Gets or sets the duration for which the VMs are up in the on-premises
 * environment.
 */
public data class AssessmentsOperationArgs(
    public val assessmentName: Output<String>? = null,
    public val azureDiskTypes: Output<List<Either<String, AzureDiskType>>>? = null,
    public val azureHybridUseBenefit: Output<Either<String, AzureHybridUseBenefit>>? = null,
    public val azureLocation: Output<String>? = null,
    public val azureOfferCode: Output<Either<String, AzureOfferCode>>? = null,
    public val azurePricingTier: Output<Either<String, AzurePricingTier>>? = null,
    public val azureStorageRedundancy: Output<Either<String, AzureStorageRedundancy>>? = null,
    public val azureVmFamilies: Output<List<Either<String, AzureVmFamily>>>? = null,
    public val currency: Output<Either<String, AzureCurrency>>? = null,
    public val discountPercentage: Output<Double>? = null,
    public val eaSubscriptionId: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val linuxAzureHybridUseBenefit: Output<Either<String, AzureHybridUseBenefit>>? = null,
    public val percentile: Output<Either<String, Percentile>>? = null,
    public val perfDataEndTime: Output<String>? = null,
    public val perfDataStartTime: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val reservedInstance: Output<Either<String, AzureReservedInstance>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scalingFactor: Output<Double>? = null,
    public val sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>? = null,
    public val timeRange: Output<Either<String, TimeRange>>? = null,
    public val vmUptime: Output<VmUptimeArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.AssessmentsOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.AssessmentsOperationArgs =
        com.pulumi.azurenative.migrate.AssessmentsOperationArgs.builder()
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .azureDiskTypes(
                azureDiskTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .azureHybridUseBenefit(
                azureHybridUseBenefit?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .azureLocation(azureLocation?.applyValue({ args0 -> args0 }))
            .azureOfferCode(
                azureOfferCode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azurePricingTier(
                azurePricingTier?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureStorageRedundancy(
                azureStorageRedundancy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .azureVmFamilies(
                azureVmFamilies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .currency(
                currency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .discountPercentage(discountPercentage?.applyValue({ args0 -> args0 }))
            .eaSubscriptionId(eaSubscriptionId?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .linuxAzureHybridUseBenefit(
                linuxAzureHybridUseBenefit?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .percentile(
                percentile?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .perfDataEndTime(perfDataEndTime?.applyValue({ args0 -> args0 }))
            .perfDataStartTime(perfDataStartTime?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .reservedInstance(
                reservedInstance?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scalingFactor(scalingFactor?.applyValue({ args0 -> args0 }))
            .sizingCriterion(
                sizingCriterion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timeRange(
                timeRange?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vmUptime(vmUptime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AssessmentsOperationArgs].
 */
@PulumiTagMarker
public class AssessmentsOperationArgsBuilder internal constructor() {
    private var assessmentName: Output<String>? = null

    private var azureDiskTypes: Output<List<Either<String, AzureDiskType>>>? = null

    private var azureHybridUseBenefit: Output<Either<String, AzureHybridUseBenefit>>? = null

    private var azureLocation: Output<String>? = null

    private var azureOfferCode: Output<Either<String, AzureOfferCode>>? = null

    private var azurePricingTier: Output<Either<String, AzurePricingTier>>? = null

    private var azureStorageRedundancy: Output<Either<String, AzureStorageRedundancy>>? = null

    private var azureVmFamilies: Output<List<Either<String, AzureVmFamily>>>? = null

    private var currency: Output<Either<String, AzureCurrency>>? = null

    private var discountPercentage: Output<Double>? = null

    private var eaSubscriptionId: Output<String>? = null

    private var groupName: Output<String>? = null

    private var linuxAzureHybridUseBenefit: Output<Either<String, AzureHybridUseBenefit>>? = null

    private var percentile: Output<Either<String, Percentile>>? = null

    private var perfDataEndTime: Output<String>? = null

    private var perfDataStartTime: Output<String>? = null

    private var projectName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var reservedInstance: Output<Either<String, AzureReservedInstance>>? = null

    private var resourceGroupName: Output<String>? = null

    private var scalingFactor: Output<Double>? = null

    private var sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>? = null

    private var timeRange: Output<Either<String, TimeRange>>? = null

    private var vmUptime: Output<VmUptimeArgs>? = null

    /**
     * @param value Machine Assessment ARM name
     */
    @JvmName("gcbnupmgcmqkofdk")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value Gets or sets the azure storage type. Premium, Standard etc.
     */
    @JvmName("aooymuqetacthejf")
    public suspend fun azureDiskTypes(`value`: Output<List<Either<String, AzureDiskType>>>) {
        this.azureDiskTypes = value
    }

    @JvmName("aewaswbqyqyngeqt")
    public suspend fun azureDiskTypes(vararg values: Output<Either<String, AzureDiskType>>) {
        this.azureDiskTypes = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the azure storage type. Premium, Standard etc.
     */
    @JvmName("pbcaoikksreleonn")
    public suspend fun azureDiskTypes(values: List<Output<Either<String, AzureDiskType>>>) {
        this.azureDiskTypes = Output.all(values)
    }

    /**
     * @param value Gets or sets the user configurable setting to display the azure hybrid use
     * benefit.
     */
    @JvmName("yipticuvjipkoqwm")
    public suspend fun azureHybridUseBenefit(`value`: Output<Either<String, AzureHybridUseBenefit>>) {
        this.azureHybridUseBenefit = value
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("hnpukqxwkvgqkaeg")
    public suspend fun azureLocation(`value`: Output<String>) {
        this.azureLocation = value
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("smbhtpwhcgcwowbe")
    public suspend fun azureOfferCode(`value`: Output<Either<String, AzureOfferCode>>) {
        this.azureOfferCode = value
    }

    /**
     * @param value Gets or sets Azure Pricing Tier - Free, Basic, etc.
     */
    @JvmName("fmrctqdhlpudluph")
    public suspend fun azurePricingTier(`value`: Output<Either<String, AzurePricingTier>>) {
        this.azurePricingTier = value
    }

    /**
     * @param value Gets or sets the Azure Storage Redundancy. Example: Locally Redundant Storage.
     */
    @JvmName("pubbxhrypvhvknca")
    public suspend fun azureStorageRedundancy(`value`: Output<Either<String, AzureStorageRedundancy>>) {
        this.azureStorageRedundancy = value
    }

    /**
     * @param value Gets or sets the Azure VM families.
     */
    @JvmName("efidmekwjtsikvcu")
    public suspend fun azureVmFamilies(`value`: Output<List<Either<String, AzureVmFamily>>>) {
        this.azureVmFamilies = value
    }

    @JvmName("emlyawpvodckisiq")
    public suspend fun azureVmFamilies(vararg values: Output<Either<String, AzureVmFamily>>) {
        this.azureVmFamilies = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the Azure VM families.
     */
    @JvmName("xvvhrxihsjpsjces")
    public suspend fun azureVmFamilies(values: List<Output<Either<String, AzureVmFamily>>>) {
        this.azureVmFamilies = Output.all(values)
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("hbcahbdelnlrllwq")
    public suspend fun currency(`value`: Output<Either<String, AzureCurrency>>) {
        this.currency = value
    }

    /**
     * @param value Custom discount percentage.
     */
    @JvmName("reewofelgloslvhk")
    public suspend fun discountPercentage(`value`: Output<Double>) {
        this.discountPercentage = value
    }

    /**
     * @param value Gets or sets enterprise agreement subscription id.
     */
    @JvmName("jmkmbohqggtpusfh")
    public suspend fun eaSubscriptionId(`value`: Output<String>) {
        this.eaSubscriptionId = value
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("cxpnwjofhxqljmsd")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Gets or sets the user configurable setting to display the linux azure hybrid use
     * benefit.
     */
    @JvmName("nnxxomxihbqouqir")
    public suspend fun linuxAzureHybridUseBenefit(`value`: Output<Either<String, AzureHybridUseBenefit>>) {
        this.linuxAzureHybridUseBenefit = value
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("cybrwsdjnltacvnj")
    public suspend fun percentile(`value`: Output<Either<String, Percentile>>) {
        this.percentile = value
    }

    /**
     * @param value Gets or sets the end time to consider performance data for assessment.
     */
    @JvmName("jvkxpjlnkwssqwqu")
    public suspend fun perfDataEndTime(`value`: Output<String>) {
        this.perfDataEndTime = value
    }

    /**
     * @param value Gets or sets the start time to consider performance data for assessment.
     */
    @JvmName("kdmhrdfstoutskfh")
    public suspend fun perfDataStartTime(`value`: Output<String>) {
        this.perfDataStartTime = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("aloukjinyudlqqri")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("tjcjfemfysiplhlj")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Gets or sets the Azure Reserved Instance - 1-Year, 3-Year.
     */
    @JvmName("paewnmiivatofgft")
    public suspend fun reservedInstance(`value`: Output<Either<String, AzureReservedInstance>>) {
        this.reservedInstance = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("prloijhtuwkvwarw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    @JvmName("iuydfjbphkyeunwv")
    public suspend fun scalingFactor(`value`: Output<Double>) {
        this.scalingFactor = value
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("jdjwoxwnwovsypln")
    public suspend fun sizingCriterion(`value`: Output<Either<String, AssessmentSizingCriterion>>) {
        this.sizingCriterion = value
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("pcoyesscwcjwnpcu")
    public suspend fun timeRange(`value`: Output<Either<String, TimeRange>>) {
        this.timeRange = value
    }

    /**
     * @param value Gets or sets the duration for which the VMs are up in the on-premises
     * environment.
     */
    @JvmName("fyhnwtokswipxihh")
    public suspend fun vmUptime(`value`: Output<VmUptimeArgs>) {
        this.vmUptime = value
    }

    /**
     * @param value Machine Assessment ARM name
     */
    @JvmName("cnvmucweifpnlpuc")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value Gets or sets the azure storage type. Premium, Standard etc.
     */
    @JvmName("iwtilkuqxydgajwm")
    public suspend fun azureDiskTypes(`value`: List<Either<String, AzureDiskType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureDiskTypes = mapped
    }

    /**
     * @param values Gets or sets the azure storage type. Premium, Standard etc.
     */
    @JvmName("jiakvgghgbyfniod")
    public suspend fun azureDiskTypes(vararg values: Either<String, AzureDiskType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureDiskTypes = mapped
    }

    /**
     * @param value Gets or sets the user configurable setting to display the azure hybrid use
     * benefit.
     */
    @JvmName("aqjklknsgocprrsc")
    public suspend fun azureHybridUseBenefit(`value`: Either<String, AzureHybridUseBenefit>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureHybridUseBenefit = mapped
    }

    /**
     * @param value Gets or sets the user configurable setting to display the azure hybrid use
     * benefit.
     */
    @JvmName("ngecgxoalrtfodjo")
    public fun azureHybridUseBenefit(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureHybridUseBenefit>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureHybridUseBenefit = mapped
    }

    /**
     * @param value Gets or sets the user configurable setting to display the azure hybrid use
     * benefit.
     */
    @JvmName("ugcdyruxeibffhqp")
    public fun azureHybridUseBenefit(`value`: AzureHybridUseBenefit) {
        val toBeMapped = Either.ofRight<String, AzureHybridUseBenefit>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureHybridUseBenefit = mapped
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("ofoligymbnnwialp")
    public suspend fun azureLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("implydlhrgpfhruw")
    public suspend fun azureOfferCode(`value`: Either<String, AzureOfferCode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("xbwgmeqgdrfrsmln")
    public fun azureOfferCode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("imxhrfcgupmnncwg")
    public fun azureOfferCode(`value`: AzureOfferCode) {
        val toBeMapped = Either.ofRight<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Gets or sets Azure Pricing Tier - Free, Basic, etc.
     */
    @JvmName("wthnywnghkhikxqd")
    public suspend fun azurePricingTier(`value`: Either<String, AzurePricingTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azurePricingTier = mapped
    }

    /**
     * @param value Gets or sets Azure Pricing Tier - Free, Basic, etc.
     */
    @JvmName("uplmcjbcodpwbyjb")
    public fun azurePricingTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzurePricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azurePricingTier = mapped
    }

    /**
     * @param value Gets or sets Azure Pricing Tier - Free, Basic, etc.
     */
    @JvmName("ikjsnrquwdmguhxo")
    public fun azurePricingTier(`value`: AzurePricingTier) {
        val toBeMapped = Either.ofRight<String, AzurePricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azurePricingTier = mapped
    }

    /**
     * @param value Gets or sets the Azure Storage Redundancy. Example: Locally Redundant Storage.
     */
    @JvmName("vuqptykfcdiqdywv")
    public suspend fun azureStorageRedundancy(`value`: Either<String, AzureStorageRedundancy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureStorageRedundancy = mapped
    }

    /**
     * @param value Gets or sets the Azure Storage Redundancy. Example: Locally Redundant Storage.
     */
    @JvmName("cpjhegccxgwlamwv")
    public fun azureStorageRedundancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureStorageRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageRedundancy = mapped
    }

    /**
     * @param value Gets or sets the Azure Storage Redundancy. Example: Locally Redundant Storage.
     */
    @JvmName("albrxjiwjhoumoxm")
    public fun azureStorageRedundancy(`value`: AzureStorageRedundancy) {
        val toBeMapped = Either.ofRight<String, AzureStorageRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageRedundancy = mapped
    }

    /**
     * @param value Gets or sets the Azure VM families.
     */
    @JvmName("ioljwvtqwstmfmmf")
    public suspend fun azureVmFamilies(`value`: List<Either<String, AzureVmFamily>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureVmFamilies = mapped
    }

    /**
     * @param values Gets or sets the Azure VM families.
     */
    @JvmName("bvwgtqvwyfkxpwbl")
    public suspend fun azureVmFamilies(vararg values: Either<String, AzureVmFamily>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureVmFamilies = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("hmwvyfkhtqnegnlt")
    public suspend fun currency(`value`: Either<String, AzureCurrency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("qeiqqwwmbjlbfjqb")
    public fun currency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("nxjiyrjdlfotrryx")
    public fun currency(`value`: AzureCurrency) {
        val toBeMapped = Either.ofRight<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Custom discount percentage.
     */
    @JvmName("hqwlvntrrkfelgpw")
    public suspend fun discountPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discountPercentage = mapped
    }

    /**
     * @param value Gets or sets enterprise agreement subscription id.
     */
    @JvmName("ubyspttubmemmgdq")
    public suspend fun eaSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eaSubscriptionId = mapped
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("pnldoekxyaoctdyt")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Gets or sets the user configurable setting to display the linux azure hybrid use
     * benefit.
     */
    @JvmName("nehmuvxywbtrrbxs")
    public suspend fun linuxAzureHybridUseBenefit(`value`: Either<String, AzureHybridUseBenefit>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxAzureHybridUseBenefit = mapped
    }

    /**
     * @param value Gets or sets the user configurable setting to display the linux azure hybrid use
     * benefit.
     */
    @JvmName("fsusggekmdsbqlkv")
    public fun linuxAzureHybridUseBenefit(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureHybridUseBenefit>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linuxAzureHybridUseBenefit = mapped
    }

    /**
     * @param value Gets or sets the user configurable setting to display the linux azure hybrid use
     * benefit.
     */
    @JvmName("rvlvdbphdpsmnamj")
    public fun linuxAzureHybridUseBenefit(`value`: AzureHybridUseBenefit) {
        val toBeMapped = Either.ofRight<String, AzureHybridUseBenefit>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linuxAzureHybridUseBenefit = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("qwdulfshcjmjvxix")
    public suspend fun percentile(`value`: Either<String, Percentile>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("tfiyphherrugrhnk")
    public fun percentile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("bdjnuevisbirmyvm")
    public fun percentile(`value`: Percentile) {
        val toBeMapped = Either.ofRight<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Gets or sets the end time to consider performance data for assessment.
     */
    @JvmName("qmbjtdtlbwrqmkxr")
    public suspend fun perfDataEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataEndTime = mapped
    }

    /**
     * @param value Gets or sets the start time to consider performance data for assessment.
     */
    @JvmName("cposomwcjfmbarpm")
    public suspend fun perfDataStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataStartTime = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("txiraycaokvvleox")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("omlndguqqksxcshd")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("oluxsvyefpiidlve")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("guinohwsrigoksmv")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Gets or sets the Azure Reserved Instance - 1-Year, 3-Year.
     */
    @JvmName("wiwvqeruehceawvr")
    public suspend fun reservedInstance(`value`: Either<String, AzureReservedInstance>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Gets or sets the Azure Reserved Instance - 1-Year, 3-Year.
     */
    @JvmName("ngeptlvyleeihtch")
    public fun reservedInstance(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Gets or sets the Azure Reserved Instance - 1-Year, 3-Year.
     */
    @JvmName("koxschvyqhhtplde")
    public fun reservedInstance(`value`: AzureReservedInstance) {
        val toBeMapped = Either.ofRight<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dvjfvuolwjojxreh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    @JvmName("aahhadmtjeteusas")
    public suspend fun scalingFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingFactor = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("rnelsfoioxuianvu")
    public suspend fun sizingCriterion(`value`: Either<String, AssessmentSizingCriterion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("qhbvhxhharflsbfn")
    public fun sizingCriterion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("ujpisuwttexowtys")
    public fun sizingCriterion(`value`: AssessmentSizingCriterion) {
        val toBeMapped = Either.ofRight<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("gohbhnqvxlsnidbt")
    public suspend fun timeRange(`value`: Either<String, TimeRange>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("ghvwytbyqdpoatqy")
    public fun timeRange(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("jbrsmsyewmgrjwhg")
    public fun timeRange(`value`: TimeRange) {
        val toBeMapped = Either.ofRight<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Gets or sets the duration for which the VMs are up in the on-premises
     * environment.
     */
    @JvmName("ihloxdwcjorbnvrj")
    public suspend fun vmUptime(`value`: VmUptimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmUptime = mapped
    }

    /**
     * @param argument Gets or sets the duration for which the VMs are up in the on-premises
     * environment.
     */
    @JvmName("btvtebinsgiscwvy")
    public suspend fun vmUptime(argument: suspend VmUptimeArgsBuilder.() -> Unit) {
        val toBeMapped = VmUptimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmUptime = mapped
    }

    internal fun build(): AssessmentsOperationArgs = AssessmentsOperationArgs(
        assessmentName = assessmentName,
        azureDiskTypes = azureDiskTypes,
        azureHybridUseBenefit = azureHybridUseBenefit,
        azureLocation = azureLocation,
        azureOfferCode = azureOfferCode,
        azurePricingTier = azurePricingTier,
        azureStorageRedundancy = azureStorageRedundancy,
        azureVmFamilies = azureVmFamilies,
        currency = currency,
        discountPercentage = discountPercentage,
        eaSubscriptionId = eaSubscriptionId,
        groupName = groupName,
        linuxAzureHybridUseBenefit = linuxAzureHybridUseBenefit,
        percentile = percentile,
        perfDataEndTime = perfDataEndTime,
        perfDataStartTime = perfDataStartTime,
        projectName = projectName,
        provisioningState = provisioningState,
        reservedInstance = reservedInstance,
        resourceGroupName = resourceGroupName,
        scalingFactor = scalingFactor,
        sizingCriterion = sizingCriterion,
        timeRange = timeRange,
        vmUptime = vmUptime,
    )
}
