@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.AvsAssessmentsOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentSizingCriterion
import com.pulumi.azurenative.migrate.kotlin.enums.AzureAvsNodeType
import com.pulumi.azurenative.migrate.kotlin.enums.AzureCurrency
import com.pulumi.azurenative.migrate.kotlin.enums.AzureLocation
import com.pulumi.azurenative.migrate.kotlin.enums.AzureOfferCode
import com.pulumi.azurenative.migrate.kotlin.enums.AzureReservedInstance
import com.pulumi.azurenative.migrate.kotlin.enums.FttAndRaidLevel
import com.pulumi.azurenative.migrate.kotlin.enums.Percentile
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.migrate.kotlin.enums.TimeRange
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AVS assessment resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### AvsAssessmentsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var avsAssessmentsOperation = new AzureNative.Migrate.AvsAssessmentsOperation("avsAssessmentsOperation", new()
 *     {
 *         AssessmentName = "asm2",
 *         AzureLocation = AzureNative.Migrate.AzureLocation.EastUs,
 *         AzureOfferCode = AzureNative.Migrate.AzureOfferCode.Msazr0003P,
 *         Currency = AzureNative.Migrate.AzureCurrency.USD,
 *         DedupeCompression = 1.5,
 *         DiscountPercentage = 0,
 *         FailuresToTolerateAndRaidLevel = AzureNative.Migrate.FttAndRaidLevel.Ftt1Raid1,
 *         GroupName = "kuchatur-test",
 *         IsStretchClusterEnabled = true,
 *         MemOvercommit = 1,
 *         NodeType = AzureNative.Migrate.AzureAvsNodeType.AV36,
 *         Percentile = AzureNative.Migrate.Percentile.Percentile95,
 *         PerfDataEndTime = "2023-09-26T13:35:56.5671462Z",
 *         PerfDataStartTime = "2023-09-25T13:35:56.5671462Z",
 *         ProjectName = "app18700project",
 *         ProvisioningState = AzureNative.Migrate.ProvisioningState.Succeeded,
 *         ReservedInstance = AzureNative.Migrate.AzureReservedInstance.RI3Year,
 *         ResourceGroupName = "ayagrawrg",
 *         ScalingFactor = 1,
 *         SizingCriterion = AzureNative.Migrate.AssessmentSizingCriterion.AsOnPremises,
 *         TimeRange = AzureNative.Migrate.TimeRange.Day,
 *         VcpuOversubscription = 4,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAvsAssessmentsOperation(ctx, "avsAssessmentsOperation", &migrate.AvsAssessmentsOperationArgs{
 * 			AssessmentName:                 pulumi.String("asm2"),
 * 			AzureLocation:                  pulumi.String(migrate.AzureLocationEastUs),
 * 			AzureOfferCode:                 pulumi.String(migrate.AzureOfferCodeMsazr0003P),
 * 			Currency:                       pulumi.String(migrate.AzureCurrencyUSD),
 * 			DedupeCompression:              pulumi.Float64(1.5),
 * 			DiscountPercentage:             pulumi.Float64(0),
 * 			FailuresToTolerateAndRaidLevel: pulumi.String(migrate.FttAndRaidLevelFtt1Raid1),
 * 			GroupName:                      pulumi.String("kuchatur-test"),
 * 			IsStretchClusterEnabled:        pulumi.Bool(true),
 * 			MemOvercommit:                  pulumi.Float64(1),
 * 			NodeType:                       pulumi.String(migrate.AzureAvsNodeTypeAV36),
 * 			Percentile:                     pulumi.String(migrate.PercentilePercentile95),
 * 			PerfDataEndTime:                pulumi.String("2023-09-26T13:35:56.5671462Z"),
 * 			PerfDataStartTime:              pulumi.String("2023-09-25T13:35:56.5671462Z"),
 * 			ProjectName:                    pulumi.String("app18700project"),
 * 			ProvisioningState:              pulumi.String(migrate.ProvisioningStateSucceeded),
 * 			ReservedInstance:               pulumi.String(migrate.AzureReservedInstanceRI3Year),
 * 			ResourceGroupName:              pulumi.String("ayagrawrg"),
 * 			ScalingFactor:                  pulumi.Float64(1),
 * 			SizingCriterion:                pulumi.String(migrate.AssessmentSizingCriterionAsOnPremises),
 * 			TimeRange:                      pulumi.String(migrate.TimeRangeDay),
 * 			VcpuOversubscription:           pulumi.Float64(4),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.AvsAssessmentsOperation;
 * import com.pulumi.azurenative.migrate.AvsAssessmentsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var avsAssessmentsOperation = new AvsAssessmentsOperation("avsAssessmentsOperation", AvsAssessmentsOperationArgs.builder()
 *             .assessmentName("asm2")
 *             .azureLocation("EastUs")
 *             .azureOfferCode("MSAZR0003P")
 *             .currency("USD")
 *             .dedupeCompression(1.5)
 *             .discountPercentage(0)
 *             .failuresToTolerateAndRaidLevel("Ftt1Raid1")
 *             .groupName("kuchatur-test")
 *             .isStretchClusterEnabled(true)
 *             .memOvercommit(1)
 *             .nodeType("AV36")
 *             .percentile("Percentile95")
 *             .perfDataEndTime("2023-09-26T13:35:56.5671462Z")
 *             .perfDataStartTime("2023-09-25T13:35:56.5671462Z")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .reservedInstance("RI3Year")
 *             .resourceGroupName("ayagrawrg")
 *             .scalingFactor(1)
 *             .sizingCriterion("AsOnPremises")
 *             .timeRange("Day")
 *             .vcpuOversubscription(4)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:AvsAssessmentsOperation asm2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/avsAssessments/{assessmentName}
 * ```
 * @property assessmentName AVS Assessment ARM name
 * @property azureLocation Azure Location or Azure region where to which the machines will be migrated.
 * @property azureOfferCode Azure Offer code according to which cost estimation is done.
 * @property currency Currency in which prices should be reported.
 * @property dedupeCompression De-duplication compression.
 * @property discountPercentage Custom discount percentage.
 * @property failuresToTolerateAndRaidLevel Failures to tolerate and RAID level in a common property.
 * @property groupName Group ARM name
 * @property isStretchClusterEnabled Is Stretch Cluster Enabled.
 * @property memOvercommit Memory overcommit.
 * @property nodeType AVS node type.
 * @property percentile Percentile of the utilization data values to be considered while assessing
 * machines.
 * @property perfDataEndTime Gets or sets the end time to consider performance data for assessment.
 * @property perfDataStartTime Gets or sets the start time to consider performance data for assessment.
 * @property projectName Assessment Project Name
 * @property provisioningState The status of the last operation.
 * @property reservedInstance Reserved instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalingFactor Percentage of buffer that user wants on performance metrics when recommending
 * Azure sizes.
 * @property sizingCriterion Assessment sizing criterion.
 * @property timeRange Time Range for which the historic utilization data should be considered for
 * assessment.
 * @property vcpuOversubscription VCPU over subscription.
 */
public data class AvsAssessmentsOperationArgs(
    public val assessmentName: Output<String>? = null,
    public val azureLocation: Output<Either<String, AzureLocation>>? = null,
    public val azureOfferCode: Output<Either<String, AzureOfferCode>>? = null,
    public val currency: Output<Either<String, AzureCurrency>>? = null,
    public val dedupeCompression: Output<Double>? = null,
    public val discountPercentage: Output<Double>? = null,
    public val failuresToTolerateAndRaidLevel: Output<Either<String, FttAndRaidLevel>>? = null,
    public val groupName: Output<String>? = null,
    public val isStretchClusterEnabled: Output<Boolean>? = null,
    public val memOvercommit: Output<Double>? = null,
    public val nodeType: Output<Either<String, AzureAvsNodeType>>? = null,
    public val percentile: Output<Either<String, Percentile>>? = null,
    public val perfDataEndTime: Output<String>? = null,
    public val perfDataStartTime: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val reservedInstance: Output<Either<String, AzureReservedInstance>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scalingFactor: Output<Double>? = null,
    public val sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>? = null,
    public val timeRange: Output<Either<String, TimeRange>>? = null,
    public val vcpuOversubscription: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.AvsAssessmentsOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.AvsAssessmentsOperationArgs =
        com.pulumi.azurenative.migrate.AvsAssessmentsOperationArgs.builder()
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .azureLocation(
                azureLocation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureOfferCode(
                azureOfferCode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .currency(
                currency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dedupeCompression(dedupeCompression?.applyValue({ args0 -> args0 }))
            .discountPercentage(discountPercentage?.applyValue({ args0 -> args0 }))
            .failuresToTolerateAndRaidLevel(
                failuresToTolerateAndRaidLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .isStretchClusterEnabled(isStretchClusterEnabled?.applyValue({ args0 -> args0 }))
            .memOvercommit(memOvercommit?.applyValue({ args0 -> args0 }))
            .nodeType(
                nodeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .percentile(
                percentile?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .perfDataEndTime(perfDataEndTime?.applyValue({ args0 -> args0 }))
            .perfDataStartTime(perfDataStartTime?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .reservedInstance(
                reservedInstance?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scalingFactor(scalingFactor?.applyValue({ args0 -> args0 }))
            .sizingCriterion(
                sizingCriterion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timeRange(
                timeRange?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vcpuOversubscription(vcpuOversubscription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AvsAssessmentsOperationArgs].
 */
@PulumiTagMarker
public class AvsAssessmentsOperationArgsBuilder internal constructor() {
    private var assessmentName: Output<String>? = null

    private var azureLocation: Output<Either<String, AzureLocation>>? = null

    private var azureOfferCode: Output<Either<String, AzureOfferCode>>? = null

    private var currency: Output<Either<String, AzureCurrency>>? = null

    private var dedupeCompression: Output<Double>? = null

    private var discountPercentage: Output<Double>? = null

    private var failuresToTolerateAndRaidLevel: Output<Either<String, FttAndRaidLevel>>? = null

    private var groupName: Output<String>? = null

    private var isStretchClusterEnabled: Output<Boolean>? = null

    private var memOvercommit: Output<Double>? = null

    private var nodeType: Output<Either<String, AzureAvsNodeType>>? = null

    private var percentile: Output<Either<String, Percentile>>? = null

    private var perfDataEndTime: Output<String>? = null

    private var perfDataStartTime: Output<String>? = null

    private var projectName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var reservedInstance: Output<Either<String, AzureReservedInstance>>? = null

    private var resourceGroupName: Output<String>? = null

    private var scalingFactor: Output<Double>? = null

    private var sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>? = null

    private var timeRange: Output<Either<String, TimeRange>>? = null

    private var vcpuOversubscription: Output<Double>? = null

    /**
     * @param value AVS Assessment ARM name
     */
    @JvmName("kiovouwdxfruxcqs")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("gtrpivjvhliopfyk")
    public suspend fun azureLocation(`value`: Output<Either<String, AzureLocation>>) {
        this.azureLocation = value
    }

    /**
     * @param value Azure Offer code according to which cost estimation is done.
     */
    @JvmName("aqssdxintyxipgnx")
    public suspend fun azureOfferCode(`value`: Output<Either<String, AzureOfferCode>>) {
        this.azureOfferCode = value
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("bashrwxsbyqtbmef")
    public suspend fun currency(`value`: Output<Either<String, AzureCurrency>>) {
        this.currency = value
    }

    /**
     * @param value De-duplication compression.
     */
    @JvmName("bhkkgxbeuenvwkpi")
    public suspend fun dedupeCompression(`value`: Output<Double>) {
        this.dedupeCompression = value
    }

    /**
     * @param value Custom discount percentage.
     */
    @JvmName("pwqftdkmtbquqivj")
    public suspend fun discountPercentage(`value`: Output<Double>) {
        this.discountPercentage = value
    }

    /**
     * @param value Failures to tolerate and RAID level in a common property.
     */
    @JvmName("cbnogtrvjykvejah")
    public suspend fun failuresToTolerateAndRaidLevel(`value`: Output<Either<String, FttAndRaidLevel>>) {
        this.failuresToTolerateAndRaidLevel = value
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("aavgymbpqrpxfttm")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Is Stretch Cluster Enabled.
     */
    @JvmName("hgwelfdieltcdihd")
    public suspend fun isStretchClusterEnabled(`value`: Output<Boolean>) {
        this.isStretchClusterEnabled = value
    }

    /**
     * @param value Memory overcommit.
     */
    @JvmName("jjeyoorqrwfavpro")
    public suspend fun memOvercommit(`value`: Output<Double>) {
        this.memOvercommit = value
    }

    /**
     * @param value AVS node type.
     */
    @JvmName("reouggaoydwtpsqs")
    public suspend fun nodeType(`value`: Output<Either<String, AzureAvsNodeType>>) {
        this.nodeType = value
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("uemldxodbimicteq")
    public suspend fun percentile(`value`: Output<Either<String, Percentile>>) {
        this.percentile = value
    }

    /**
     * @param value Gets or sets the end time to consider performance data for assessment.
     */
    @JvmName("haosmjaccaiwsxen")
    public suspend fun perfDataEndTime(`value`: Output<String>) {
        this.perfDataEndTime = value
    }

    /**
     * @param value Gets or sets the start time to consider performance data for assessment.
     */
    @JvmName("lviasuumolvtcmgg")
    public suspend fun perfDataStartTime(`value`: Output<String>) {
        this.perfDataStartTime = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ejlksmfbmuhdsika")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("ncgwydvombwgaclj")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("husmbvstmaorefpu")
    public suspend fun reservedInstance(`value`: Output<Either<String, AzureReservedInstance>>) {
        this.reservedInstance = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eowummcrxrmdokpv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    @JvmName("uimjqgxjlwodapsr")
    public suspend fun scalingFactor(`value`: Output<Double>) {
        this.scalingFactor = value
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("mkusyhjrgdevemds")
    public suspend fun sizingCriterion(`value`: Output<Either<String, AssessmentSizingCriterion>>) {
        this.sizingCriterion = value
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("urygkbrkuiuhctpr")
    public suspend fun timeRange(`value`: Output<Either<String, TimeRange>>) {
        this.timeRange = value
    }

    /**
     * @param value VCPU over subscription.
     */
    @JvmName("huhwehrpnrrvovlw")
    public suspend fun vcpuOversubscription(`value`: Output<Double>) {
        this.vcpuOversubscription = value
    }

    /**
     * @param value AVS Assessment ARM name
     */
    @JvmName("iawijqnfjmpshfov")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("bparvpgwqcoluocy")
    public suspend fun azureLocation(`value`: Either<String, AzureLocation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("ywoggqxpbynnfhxy")
    public fun azureLocation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("shagywfvcbglomfa")
    public fun azureLocation(`value`: AzureLocation) {
        val toBeMapped = Either.ofRight<String, AzureLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Azure Offer code according to which cost estimation is done.
     */
    @JvmName("vaqnmeevbspextca")
    public suspend fun azureOfferCode(`value`: Either<String, AzureOfferCode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Azure Offer code according to which cost estimation is done.
     */
    @JvmName("kvrrcyknhjbvnsls")
    public fun azureOfferCode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Azure Offer code according to which cost estimation is done.
     */
    @JvmName("yajqrffxjjgkrcww")
    public fun azureOfferCode(`value`: AzureOfferCode) {
        val toBeMapped = Either.ofRight<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("tjhfhitxerbnfeyg")
    public suspend fun currency(`value`: Either<String, AzureCurrency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("ufkwqfwgqbhvsxsq")
    public fun currency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("qshprwlfjlrrffxp")
    public fun currency(`value`: AzureCurrency) {
        val toBeMapped = Either.ofRight<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value De-duplication compression.
     */
    @JvmName("fjooigwtwysfjums")
    public suspend fun dedupeCompression(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedupeCompression = mapped
    }

    /**
     * @param value Custom discount percentage.
     */
    @JvmName("tjkfvyivgloxnaml")
    public suspend fun discountPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discountPercentage = mapped
    }

    /**
     * @param value Failures to tolerate and RAID level in a common property.
     */
    @JvmName("nswbvxlmimhtfeht")
    public suspend fun failuresToTolerateAndRaidLevel(`value`: Either<String, FttAndRaidLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failuresToTolerateAndRaidLevel = mapped
    }

    /**
     * @param value Failures to tolerate and RAID level in a common property.
     */
    @JvmName("ogyvyutvoigtxios")
    public fun failuresToTolerateAndRaidLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FttAndRaidLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failuresToTolerateAndRaidLevel = mapped
    }

    /**
     * @param value Failures to tolerate and RAID level in a common property.
     */
    @JvmName("jhnsxorsjtpffejd")
    public fun failuresToTolerateAndRaidLevel(`value`: FttAndRaidLevel) {
        val toBeMapped = Either.ofRight<String, FttAndRaidLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failuresToTolerateAndRaidLevel = mapped
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("xeuosxjbhgwmdakk")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Is Stretch Cluster Enabled.
     */
    @JvmName("svgwpdryluvxexau")
    public suspend fun isStretchClusterEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isStretchClusterEnabled = mapped
    }

    /**
     * @param value Memory overcommit.
     */
    @JvmName("uqwydkumhyrrhudk")
    public suspend fun memOvercommit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memOvercommit = mapped
    }

    /**
     * @param value AVS node type.
     */
    @JvmName("bsptuaqglikeesge")
    public suspend fun nodeType(`value`: Either<String, AzureAvsNodeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    /**
     * @param value AVS node type.
     */
    @JvmName("jmjvtfqxtdngqrqt")
    public fun nodeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureAvsNodeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    /**
     * @param value AVS node type.
     */
    @JvmName("xnwywynlldfdooer")
    public fun nodeType(`value`: AzureAvsNodeType) {
        val toBeMapped = Either.ofRight<String, AzureAvsNodeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("hauqxcpandkhjoat")
    public suspend fun percentile(`value`: Either<String, Percentile>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("ibbakxmrobdqetnv")
    public fun percentile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("slemqiasbqgdmems")
    public fun percentile(`value`: Percentile) {
        val toBeMapped = Either.ofRight<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Gets or sets the end time to consider performance data for assessment.
     */
    @JvmName("palscmepenpsnnfm")
    public suspend fun perfDataEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataEndTime = mapped
    }

    /**
     * @param value Gets or sets the start time to consider performance data for assessment.
     */
    @JvmName("ojnrsfmweasotgjc")
    public suspend fun perfDataStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataStartTime = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("bpymtlgdjvplaofa")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("rdotducciclxnyfc")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("oylbueqocccteakn")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("ytsbdiswdtcltiyg")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("xogqbrdwajdnmjbd")
    public suspend fun reservedInstance(`value`: Either<String, AzureReservedInstance>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("vsurjmeqgfvqawoq")
    public fun reservedInstance(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("bouqqmgkvwqipobh")
    public fun reservedInstance(`value`: AzureReservedInstance) {
        val toBeMapped = Either.ofRight<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iulbtchdciintrdc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    @JvmName("gmdgffapyveyrsvv")
    public suspend fun scalingFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingFactor = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("mfobjcdtlskwpgbp")
    public suspend fun sizingCriterion(`value`: Either<String, AssessmentSizingCriterion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("pimcnuahjtxdjnha")
    public fun sizingCriterion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("iypuievvvjcuiwjl")
    public fun sizingCriterion(`value`: AssessmentSizingCriterion) {
        val toBeMapped = Either.ofRight<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("nmwhiayaxfrvcehk")
    public suspend fun timeRange(`value`: Either<String, TimeRange>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("bxtygsjanyvyrymg")
    public fun timeRange(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("vauyqdcjspyakfkq")
    public fun timeRange(`value`: TimeRange) {
        val toBeMapped = Either.ofRight<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value VCPU over subscription.
     */
    @JvmName("dqsgrylysucjgipm")
    public suspend fun vcpuOversubscription(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcpuOversubscription = mapped
    }

    internal fun build(): AvsAssessmentsOperationArgs = AvsAssessmentsOperationArgs(
        assessmentName = assessmentName,
        azureLocation = azureLocation,
        azureOfferCode = azureOfferCode,
        currency = currency,
        dedupeCompression = dedupeCompression,
        discountPercentage = discountPercentage,
        failuresToTolerateAndRaidLevel = failuresToTolerateAndRaidLevel,
        groupName = groupName,
        isStretchClusterEnabled = isStretchClusterEnabled,
        memOvercommit = memOvercommit,
        nodeType = nodeType,
        percentile = percentile,
        perfDataEndTime = perfDataEndTime,
        perfDataStartTime = perfDataStartTime,
        projectName = projectName,
        provisioningState = provisioningState,
        reservedInstance = reservedInstance,
        resourceGroupName = resourceGroupName,
        scalingFactor = scalingFactor,
        sizingCriterion = sizingCriterion,
        timeRange = timeRange,
        vcpuOversubscription = vcpuOversubscription,
    )
}
